<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve user_id and challenge_id from the POST request
    $userId = isset($_POST['user_id']) ? $_POST['user_id'] : null;
    $challengeId = isset($_POST['challenge_id']) ? $_POST['challenge_id'] : null;

    if ($userId !== null && $challengeId !== null) {
        // Check if user_id and challenge_id exist in the achievements table
        $achievementRow = $general->get_Onerow("achievements", "AND user_id = $userId AND challenge_id = $challengeId");

        if ($achievementRow) {
            // If the row exists, delete it
            $deleteResult = $general->del_Row("achievements", "user_id = $userId AND challenge_id = $challengeId");
            
            if ($deleteResult === "") {
                echo json_encode(['success' => true, 'message' => 'Achievement row deleted successfully']);
            } else {
                echo json_encode(['error' => 'Failed to delete achievement row']);
            }
        } else {
            // Get start_date, end_date, end_time, and reward_points from user_challenges table
            $userChallengeRow = $general->get_Onerow("user_challenges", "AND user_id = $userId AND challenge_id = $challengeId AND completed='yes'", "start_date, end_date, end_time, reward_points");

            if ($userChallengeRow) {
                // Count the rows of the achievements table with the given user_id
                $achievementCount = $general->get_AllRowscnt("achievements", "AND user_id = $userId");

                // Get the user's achievement column value from the user_details table
                $userAchievementRow = $general->get_Onerow("user_details", "AND id = $userId", "achievement");

                if ($userAchievementRow && $achievementCount < $userAchievementRow['achievement']) {
                    // Insert a new row in the achievements table
                    $insertResult = $general->ins_Row("achievements", "challenge_id, user_id, start_date, end_date, end_time, reward_points", "$challengeId, $userId, '{$userChallengeRow['start_date']}', '{$userChallengeRow['end_date']}', '{$userChallengeRow['end_time']}', {$userChallengeRow['reward_points']}");

                    if ($insertResult === "") {
                        echo json_encode(['success' => true, 'message' => 'Achievement row inserted successfully']);
                    } else {
                        echo json_encode(['error' => 'Failed to insert achievement row']);
                    }
                } else {
                    echo json_encode(['error' => 'User achievement count is not less than the user achievement column']);
                }
            } else {
                echo json_encode(['error' => 'No matching user_challenge row found']);
            }
        }
    } else {
        echo json_encode(['error' => 'Missing user_id or challenge_id parameter']);
    }
} else {
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
?>
