<?php

require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST')
{
    $user_id = $_POST['user_id'] ?? null;
    $imageFile = $_FILES['imageFile'] ?? null;
    $challenge_id = $_POST['challenge_id'] ?? null;
    $moderator_id = $_POST['moderator_id'] ?? null;
    $page_id = $_POST['page_id'] ?? null;
    $completed_id = $_POST['completed_id'] ?? null;


    if (!$user_id || !$imageFile || !$challenge_id)
    {
        echo json_encode(['error' => 'Missing required fields']);
        exit();
    }

    if ($imageFile['error'] !== UPLOAD_ERR_OK)
    {
        echo json_encode(['error' => 'File upload failed', 'imageFile' => $imageFile]);
        exit();
    }

    $upload = $general->upload_file("imageFile", "image", 'image', "photos");

    if ($upload[1] != "")
    {
        echo json_encode(['error' => $upload[1]]);
        exit();
    }
    else
    {
        $image_name = $upload[0];
    }



    $msg = $general->ins_Row(
        'approval',
        ' user_id, image, challenge_id, page_id, moderator_id, completed_id',
        " '$user_id', '$image_name', '$challenge_id', '$page_id', '$moderator_id', '$completed_id'"
    );






    if (empty($msg))
    {
        echo json_encode(['success' => true]);
    }
    else
    {
        echo json_encode(['error' => $msg]);
    }
}
else
{
    echo json_encode(['error' => 'Invalid request method']);
}
