<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST')
{
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    // Check if id is provided in the request
    $user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : null;
    $parent_comment_id = isset($_POST['parent_comment_id']) ? $_POST['parent_comment_id'] : null;
    $sub_parent = isset($_POST['sub_parent']) ? $_POST['sub_parent'] : null;
    $comment_text = isset($_POST['comment_text']) ? $_POST['comment_text'] : null;
    $people_id = isset($_POST['people_id']) ? $_POST['people_id'] : null;

    if ($user_id !== null)
    {
        // Sanitize inputs
        $comment_text = $general->baseencode($comment_text);

        // Check if the parent comment id is 0 or null
        if ($parent_comment_id == 0 || $parent_comment_id == null)
        {
            $parent_comment_id = NULL;
        }
        if ($sub_parent == 0 || $sub_parent == null)
        {
            $sub_parent = NULL;
        }

        // Insert the comment into the database
        if ($parent_comment_id != null)
        {

            if ($sub_parent != null)
            {
                $result = $general->ins_Row(
                    'comments',
                    'parent_comment_id, sub_parent, user_id, people_id,comment_text',
                    "'$parent_comment_id', '$sub_parent', '$user_id', '$people_id', '$comment_text'"
                );
                $parent_comm_arr = $general->get_Onerow("comments", " and id=" . $parent_comment_id);
                $sub_parent_comm_arr = $general->get_Onerow("comments", " and id=" . $sub_parent);

                $other_user = $sub_parent_comm_arr['user_id'];
                $type = "people_replied";
                if ($other_user != $user_id)
                {
                    $msg = $general->ins_Row(
                        'notifications',
                        'user_id,notification_type, people_data_id,other_user',
                        "'$other_user','$type' ,'$people_id', '$user_id'"
                    );
                    $parent_comm_arr = $general->get_Onerow("user_comments", " and id=" . $parent_comment_id);

                $other_user = $parent_comm_arr['user_id'];
                $type = "people_replied";
                if ($other_user != $user_id)
                {
                    $msg = $general->ins_Row(
                        'notifications',
                        'user_id,notification_type, people_data_id,other_user',
                        "'$other_user','$type' ,'$people_id', '$user_id'"
                    );
                }
                }
            }
            else
            {
                $result = $general->ins_Row(
                    'comments',
                    'parent_comment_id, user_id, people_id,comment_text',
                    "'$parent_comment_id', '$user_id', '$people_id', '$comment_text'"
                );
            }
        }
        else
        {
            $result = $general->ins_Row(
                'comments',
                'user_id, people_id,comment_text',
                "'$user_id', '$people_id', '$comment_text'"
            );
        }

        if ($result === "")
        {
            echo json_encode(['success' => true, 'message' => 'Comment added successfully']);
        }
        else
        {
            echo json_encode(['error' => 'Failed to add comment']);
        }
    }
    else
    {
        echo json_encode(['error' => 'Missing user_id parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
