<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST')
{
    error_reporting(E_ALL);
ini_set('display_errors', 1);

    // Check if all required fields are present
    if (!isset($_POST['user_id'], $_POST['type'], $_POST['page_id'])) {
        echo json_encode(['error' => 'One or more required fields are missing','post'=>$_POST]);
        exit();
    }

    // Retrieve POST data
    $user_id = $_POST['user_id'];
    $type = $_POST['type'];
    $page_id = $_POST['page_id'];
    
    // Check if optional fields are set
    $textData = isset($_POST['textData']) ? $_POST['textData'] : null;
    $imageFile = isset($_FILES['imageFile']) ? $_FILES['imageFile'] : null;
    $videoFile = isset($_FILES['videoFile']) ? $_FILES['videoFile'] : null;

    // Upload image file
    $image_name = "";
    if ($imageFile && $imageFile['error'] === UPLOAD_ERR_OK)
    {
        $upload = $general->upload_file("imageFile", "image", 'image', "photos");
        if ($upload[1] != "") {
            echo json_encode(['error' => $upload[1]]);
            exit();
        }
        $image_name = $upload[0];
    }

    // Upload video file
    $video_name = "";
    if ($videoFile && $videoFile['error'] === UPLOAD_ERR_OK)
    {
        $upload = $general->upload_file("videoFile", "video", 'video', "videos");
        if ($upload[1] != "") {
            echo json_encode(['error' => $upload[1]]);
            exit();
        }
        $video_name = $upload[0];
    }

    // Insert complaint record into the database
    $msg = $general->ins_Row(
        'complaint',
        'type, page_id, user_id, textData, image, video',
        "'$type', '$page_id', '$user_id', '$textData', '$image_name', '$video_name'"
    );

    if (empty($msg))
    {
        echo json_encode(['success' => true,'post'=>$_POST]);
    }
    else
    {
        echo json_encode(['error' => $msg]);
    }
}
else
{
    echo json_encode(['error' => 'Invalid request method']);
}

?>