<?php

require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

use FFMpeg\FFMpeg;
use FFMpeg\Coordinate\Point;
use FFMpeg\Coordinate\Dimension;
use FFMpeg\Filters\Video\VideoFilters;
use FFMpeg\Format\Video\X264;

if ($_SERVER['REQUEST_METHOD'] === 'POST')
{
    $task_id = $_POST['taskId'] ?? null;
    $user_id = $_POST['userSId'] ?? null;
    $userTaskId = $_POST['userTaskId'] ?? null;
    $imageFile = $_FILES['imageFile'] ?? null;
    $challenge_id = $_POST['challenge_id'] ?? null;
    $media_type = $_POST['media_type'] ?? null;

    if (!$task_id || !$user_id || !$userTaskId || !$imageFile || !$challenge_id || !$media_type)
    {
        echo json_encode(['error' => 'Missing required fields']);
        exit();
    }

    if ($imageFile['error'] !== UPLOAD_ERR_OK)
    {
        echo json_encode(['error' => 'File upload failed']);
        exit();
    }

    $upload = ($media_type == "photo") ?
        $general->upload_file("imageFile", "image", 'image', "photos") :
        $general->upload_file("imageFile", "video", 'video', "videos");

    if ($upload[1] != "")
    {
        echo json_encode(['error' => $upload[1]]);
        exit();
    }
    else
    {
        $image_name = $upload[0];
    }
    if ($media_type == "photo")
    {
        $uploadedImagePath = ROOT_SITE . "/photos/" . $image_name;
        $uploadedImage = imagecreatefromstring(file_get_contents($uploadedImagePath));

        // Load the logo image
        $logoPath = ROOT_SITE . "/photos/logo.png"; // Assuming logo.png is in the "photos" folder
        $logo = imagecreatefrompng($logoPath);

        imagesavealpha($logo, true);

        // Get dimensions of the uploaded image and the logo
        $uploadedImageWidth = imagesx($uploadedImage);
        $uploadedImageHeight = imagesy($uploadedImage);
        $logoWidth = imagesx($logo);
        $logoHeight = imagesy($logo);

        // Resize the logo to fit the uploaded image
        $logoNewWidth = min($uploadedImageWidth / 4, $logoWidth);
        $logoNewHeight = ($logoNewWidth / $logoWidth) * $logoHeight;

        // Create a new image for the resized logo
        $logoResized = imagecreatetruecolor($logoNewWidth, $logoNewHeight);
        imagecopyresampled($logoResized, $logo, 0, 0, 0, 0, $logoNewWidth, $logoNewHeight, $logoWidth, $logoHeight);

        // Calculate the position to place the logo (bottom-right corner with some padding)
        $padding = 10;
        $positionX = $uploadedImageWidth - $logoNewWidth - $padding;
        $positionY = $uploadedImageHeight - $logoNewHeight - $padding;

        // Merge the resized logo onto the uploaded image
        imagecopy($uploadedImage, $logoResized, $positionX, $positionY, 0, 0, $logoNewWidth, $logoNewHeight);

        // Save the image with the watermark
        imagepng($uploadedImage, $uploadedImagePath);

        // Free memory
        imagedestroy($uploadedImage);
        imagedestroy($logo);
        imagedestroy($logoResized);
    }
    // else
    // {
    //     $uploadedMediaPath = ROOT_SITE . "/videos/" . $image_name;
    //     $watermarkedVideoPath = ROOT_SITE . "/videos/watermarked_" . $image_name;
    //     $watermarkPath = ROOT_SITE . "/photos/logo.png"; // Path to the watermark image

    //     // Use PHP-FFmpeg to add watermark to video
    //     $ffmpeg = FFMpeg::create();
    //     $video = $ffmpeg->open($uploadedMediaPath);

    //     // Add watermark using VideoFilters
    //     $videoFilters = new VideoFilters($video);
    //     $videoFilters->watermark($watermarkPath, [
    //         'position' => 'relative',
    //         'bottom' => 10,
    //         'right' => 10,
    //     ]);

    //     // Choose output format for the video
    //     $format = new X264('aac', 'libx264');

    //     // Save watermarked video
    //     $video->save($format, $watermarkedVideoPath);

    //     // Check if watermarked video was successfully created
    //     if (!file_exists($watermarkedVideoPath)) {
    //         echo json_encode(['error' => 'Failed to add watermark to video']);
    //         exit();
    //     }
    //     $image_name = "watermarked_" . $image_name;
    // }

    $end_date = date('Y-m-d H:i:s');
    $end_time = date('H:i:s');
    $yes = "yes";
    $no = 'no';

    $msg = $general->upd_Row("user_tasks", "end_date='$end_date', approved='$no', completed='$yes', end_time='$end_time'", "id=$userTaskId");
    if ($media_type == "photo")
    {
        $msg = $general->upd_Row("user_tasks", "image='$image_name'", "id=$userTaskId");
    }
    else
    {
        $msg = $general->upd_Row("user_tasks", "video='$image_name'", "id=$userTaskId");
    }

    $challenges_arr = $general->get_Onerow("challenges", "and challenge_id =" . $challenge_id);

    if ($challenges_arr['frequency'] == "contest")
    {
        $page_id = $challenges_arr['page_id'];
        $zero = 0;
        $msg = $general->ins_Row(
            'contest',
            'user_id,media_path,challenge_id,page_id,like_count,task_id,type',
            "'$user_id','$image_name','$challenge_id','$page_id','$zero','$task_id','$media_type'"
        );
    }

    if (empty($msg))
    {
        echo json_encode(['success' => true]);
    }
    else
    {
        echo json_encode(['error' => $msg, 'message' => $challenges_arr]);
    }
}
else
{
    echo json_encode(['error' => 'Invalid request method']);
}
