<?php

require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST')
{
    $user_id = $_POST['user_id'] ?? null;
    $caption = $_POST['caption'] ?? null;
    $imageFile = $_FILES['imageFile'] ?? null;
    $challenge_id = $_POST['challenge_id'] ?? null;

    if (!$user_id || !$caption || !$imageFile || !$challenge_id)
    {
        echo json_encode(['error' => 'Missing required fields']);
        exit();
    }

    if ($imageFile['error'] !== UPLOAD_ERR_OK)
    {
        echo json_encode(['error' => 'File upload failed','imageFile'=>$imageFile]);
        exit();
    }

    $upload = $general->upload_file("imageFile", "image", 'image', "photos");

    if ($upload[1] != "")
    {
        echo json_encode(['error' => $upload[1]]);
        exit();
    }
    else
    {
        $image_name = $upload[0];
    }

    $wheres = " and challenge_id=" . $challenge_id;
    $challenge = $general->get_Onerow("challenges", $wheres);
    if (empty($challenge))
    {
        echo json_encode(['error' => 'No challenge Exist']);
        exit();
    }

    $page_id = $challenge['page_id'];
    $task_details = $general->get_Onerow("tasks", $wheres);
    if (empty($task_details))
    {
        echo json_encode(['error' => 'No task Exist']);
        exit();
    }
    $task_id = $task_details['task_id'];

    $cert_where = " and challenge_id=" . $challenge_id . " and task_id=" . $task_id . " and user_id=" . $user_id;
    $people_arr = $general->get_Onerow("people_data", $cert_where);
    $end_date = date('Y-m-d H:i:s');

    if (empty($people_arr))
    {
        $msg = $general->ins_Row(
            'people_data',
            'user_id, task_id, challenge_id, page_id',
            "'$user_id', '$task_id', '$challenge_id', '$page_id'"
        );
        $people_data_id = $general->get_insetId();

        $msg = $general->ins_Row(
            'people_media',
            'caption, user_id, image, challenge_id, page_id, people_data_id, task_id',
            "'$caption', '$user_id', '$image_name', '$challenge_id', '$page_id', '$people_data_id', '$task_id'"
        );
        $active="active";

        $msg4 = $general->ins_Row(
            'certificates',
            'challenge_id, page_id, user_id, end_date, people_data_id, task_id,status',
            "'$challenge_id', '$page_id', '$user_id', '$end_date', '$people_data_id', '$task_id', '$active'"
        );
    }
    else
    {
        $people_data_id  = $people_arr['id'];
        $msg = $general->ins_Row(
            'people_media',
            'caption, user_id, image, challenge_id, page_id, people_data_id, task_id',
            "'$caption', '$user_id', '$image_name', '$challenge_id', '$page_id', '$people_data_id', '$task_id'"
        );
    }



    if (empty($msg))
    {
        echo json_encode(['success' => true]);
    }
    else
    {
        echo json_encode(['error' => $msg]);
    }
}
else
{
    echo json_encode(['error' => 'Invalid request method']);
}
