<?php
require_once("cors.php");
require_once("includes/general.class.php");
require_once("vendor/autoload.php"); // Include the JWT library

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

$general = new general();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST')
{
    $type               = "ordered";
    $district_id        = isset($_POST['district']) ? $_POST['district'] : null;
    $page_id        = isset($_POST['page_id']) ? $_POST['page_id'] : null;

    // Parse start date
    $startDate          = isset($_POST['startDate']) ? date('Y-m-d H:i:s', strtotime(preg_replace('/\(.*\)/', '', $_POST['startDate']))) : null;

    // Parse end date
    $endDate            = isset($_POST['endDate']) ? date('Y-m-d H:i:s', strtotime(preg_replace('/\(.*\)/', '', $_POST['endDate']))) : null;

    $entryPoints        = isset($_POST['entryPoints']) ? $_POST['entryPoints'] : null;
    $rewardPoints       = isset($_POST['rewardPoints']) ? $_POST['rewardPoints'] : null;
    $level              = isset($_POST['level']) ? $_POST['level'] : null;
    $description        = isset($_POST['description']) ? $general->baseencode($_POST['description']) : null;
    $title              = isset($_POST['title']) ? $_POST['title'] : null;

    // Set startTime to 00:00:01 and endTime to 23:59:59
    $startTime = "00:00:01";
    $endTime = "23:59:59";

    $frequency          = "challenges";
    $arena              = "no";
    $visit              = "yes";
    $created_by         = "Admin";


    // Proceed with inserting data
    if (isset($_FILES["image"]) && $_FILES["image"]['error'] === UPLOAD_ERR_OK)
    {
        $upload = $general->upload_file("image", "image", 'image', "photos");

        if ($upload[1] != "")
        {
            echo json_encode(['error' => $upload[1]]);
            exit();
        }
        else
        {
            $image_name = $upload[0];
        }

        $msg = $general->ins_Row(
            'challenges',
            'page_id,challenge_type, district_id, start_date, end_date, title, start_time, end_time, entry_points, reward_points, level, description, frequency, arena, visit, created_by',
            "'$page_id', '$type', '$district_id', '$startDate', '$endDate','$title', '$startTime', '$endTime', '$entryPoints', '$rewardPoints', '$level', '$description', '$frequency', '$arena', '$visit', '$created_by'"
        );

        $challenge_id = $general->get_insetId();
        $photo = "photo";
        $msg = $general->ins_Row(
            'challenge_media',
            'challenge_id, media_type, media_path',
            "'$challenge_id', '$photo', '$image_name'"
        );
        if (empty($msg))
        {
            echo json_encode(['success' => true]);
        }
        else
        {
            echo json_encode(['error' => 'Failed to update challenge details']);
        }
    }
    else
    {
        echo json_encode(['error' => 'failed to upload image']);
    }
}
else
{
    echo json_encode(['error' => 'Invalid request method']);
}
