<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $caption = isset($_POST['caption']) ? $_POST['caption'] : null;
    $video = isset($_POST['video']) ? $_POST['video'] : null;
    $image = isset($_POST['image']) ? $_POST['image'] : null;
    $textData = isset($_POST['textData']) ? $general->baseencode($_POST['textData']) : null;
    $page_id = isset($_POST['page_id']) ? $_POST['page_id'] : null;
    $type = isset($_POST['type']) ? $_POST['type'] : null;
    $sub_page = isset($_POST['district']) ? $_POST['district'] : null;

    // Check type and insert data accordingly
    switch ($type) {
        case 'text':
            $fields = 'caption, textData, page_id, type, sub_page';
            $values = "'', '$textData', '$page_id', '$type', '$sub_page'";
            break;
        case 'image':
            if (!empty($caption) && isset($_FILES["image"]) && $_FILES["image"]['error'] === UPLOAD_ERR_OK) {
                $upload = $general->upload_file("image", "image", 'image', "photos");

                if ($upload[1] != "") {
                    echo json_encode(['error' => $upload[1]]);
                    exit();
                } else {
                    $image_name = $upload[0];
                }
                $fields = 'caption, image, page_id, type, sub_page';
                $values = "'$caption', '$image_name', '$page_id', '$type', '$sub_page'";
            } else {
                echo json_encode(['error' => 'Missing caption or failed to upload image']);
                exit();
            }
            break;
        case 'video':
            if (!empty($caption) && isset($_FILES["video"]) && $_FILES["video"]['error'] === UPLOAD_ERR_OK) {
                $upload = $general->upload_file("video", "video", 'video', "videos");

                if ($upload[1] != "") {
                    echo json_encode(['error' => $upload[1]]);
                    exit();
                } else {
                    $video_name = $upload[0];
                }
                $fields = 'caption, video, page_id, type, sub_page';
                $values = "'$caption', '$video_name', '$page_id', '$type', '$sub_page'";
            } else {
                echo json_encode(['error' => 'Missing caption or failed to upload video']);
                exit();
            }
            break;
        default:
            echo json_encode(['error' => 'Invalid post type']);
            exit();
    }

    // Insert data into posts table
    $msg = $general->ins_Row('posts', $fields, $values);

    if (empty($msg)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['error' => 'Failed to insert post data']);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}
