<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    // Check if task_id is provided in the request
    $page_id = isset($_GET['page_id']) ? $_GET['page_id'] : null;

    if ($page_id !== null)
    {

        $data = array();
        $where = " and approved='no' and rejected='no' and completed='yes'";

        $task = array();
       
        $task_count = $general->get_AllRowscnt("user_tasks", $where);
        if ($task_count > 0)
        {
            $task_arr = $general->get_AllRows("user_tasks", 0, $task_count, "id desc", $where);

            foreach ($task_arr as $key => $val)
            {
                $challenge_array = array();
                $page_array = array();
                $task_details   = $general->get_Onerow("tasks", "and task_id =" . $val['task_id']);
                $challenges_arr = $general->get_Onerow("challenges", "and challenge_id =" . $task_details['challenge_id']);
                $page_details = $general->get_Onerow("page", "and id =" . $challenges_arr['page_id']);

                $task[$key]['id'] = $val['id'];
                $task[$key]['page_id'] = $challenges_arr['page_id'];
                $task[$key]['task_id'] = $task_details['task_id'];
                $task[$key]['challenge_id'] = $task_details['challenge_id'];
                $task[$key]['task_name'] = $task_details['task_name'];
                $task[$key]['description'] = $general->basedecode($task_details['description']);
                $task[$key]['challenge_type'] = $challenges_arr['challenge_type'];
                $task[$key]['frequency'] = $challenges_arr['frequency'];
                $task[$key]['start_date'] = $task_details['start_date'];
                $task[$key]['start_time'] = $task_details['start_time'];
                $task[$key]['end_date'] = $task_details['end_date'];
                $task[$key]['end_time'] = $task_details['end_time'];
                $task[$key]['task_type'] = $task_details['task_type'];
                $task[$key]['image_task'] = $val['image'];
                $task[$key]['video_task'] = $val['video'];
                $task[$key]['verification_method'] = $task_details['verification_method'];
                $task[$key]['entry_points'] = $task_details['entry_points'];
                $task[$key]['reward_points'] = $task_details['reward_points'];
                $task[$key]['reward_cash'] = $task_details['reward_cash'];
                $task[$key]['verification_points'] = $task_details['verification_points'];
                $task[$key]['is_certificate'] = $task_details['is_certificate'];
                $task[$key]['is_badge'] = $task_details['is_badge'];
                $task[$key]['player_level'] = $task_details['player_level'];
                $task[$key]['created_date'] = $task_details['created_date'];
                $task[$key]['created_by'] = $task_details['created_by'];
                $task[$key]['participants_count'] = $task_details['participants_count'];
                $task[$key]['active'] = $task_details['active'];
                $task[$key]['removed_date'] = $task_details['removed_date'];
                $task[$key]['removed_by'] = $task_details['removed_by'];
                $challenge_array['challenge_id'] = $task_details['challenge_id'];
                $challenge_array['frequency'] = $challenges_arr['frequency'];
                $page_array['image'] = $page_details['icon'];
                $page_array['title'] = $page_details['title'];
                $task[$key]['challenge'] = $challenge_array;
                $task[$key]['selectedMovie'] = $page_array;
                $taskId = $task_details['task_id'];
                $task[$key]['id'] = $val['id'];
                $task[$key]['challenge_title'] = $challenges_arr['title'];

                $task[$key]['val_task_id'] = $val['task_id'];
                $task[$key]['val_user_id'] = $val['user_id'];
                $task[$key]['val_reward_points'] = $val['reward_points'];
                $task[$key]['val_approved'] = $val['approved'];
                $task[$key]['val_entry_points'] = $val['entry_points'];
                $task[$key]['val_rejected'] = $val['rejected'];
                $task[$key]['val_start_date'] = $val['start_date'];
                $task[$key]['val_start_time'] = $val['start_time'];
                $task[$key]['val_end_date'] = $val['end_date'];
                $task[$key]['val_end_time'] = $val['end_time'];
                $task[$key]['val_completed'] = $val['completed'];
                $task[$key]['val_approved_by'] = $val['approved_by'];

                $task_image_arr = $general->get_Onerow("task_media", "and task_id =" . $taskId);
                $task[$key]['image'] = $task_image_arr['media_path'];


                $rel_where = " and challenge_id=" . $task_details['challenge_id'];

                $task_relation = $general->get_Onerow("task_relation", $rel_where);

                if ($task_relation != "")
                {
                    $task[$key]['multiple'] = "yes";
                }
                else
                {
                    $task[$key]['multiple'] = "no";
                }
                // if ($task_details['task_type'] == "map")
                // {

                //     $where = " and task_id=" . $taskId;
                //     $tasksMaps = $general->get_Onerow("task_map", $where);

                //     // Include map-related information in the response
                //     $mapInfo = array(
                //         'map_id' => $tasksMaps['map_id'],
                //         'task_id' => $tasksMaps['task_id'],
                //         'challenge_id' => $tasksMaps['challenge_id'],
                //         'reach_distance' => $tasksMaps['reach_distance'],
                //         'latitude' => $tasksMaps['latitude'],
                //         'longitude' => $tasksMaps['longitude'],
                //         // ... (include other fields as needed)
                //     );

                //     $task[$key]['map_info'] = $mapInfo;
                // }
                if ($task_details['task_type'] == "stepCounter")
                {
                    $ped_where = " and task_id=" . $taskId;
                    $task_pedometer     = $general->get_Onerow("task_pedometer", $ped_where);
                    $task[$key]['steps']      = $task_pedometer['steps'];
                    $task[$key]['direction']  = $task_pedometer['direction'];
                }
                if ($task_details['task_type'] == "mediaCapture")
                {
                    $med_where = " and task_id=" . $taskId;
                    $media_tasks     = $general->get_Onerow("media_tasks", $med_where);
                    $task[$key]['media_type']      = $media_tasks['media_type'];
                    $task[$key]['title_media']  = $media_tasks['title'];
                }
                if ($task_details['task_type'] == "videoCapture")
                {
                    $vid_where = " and task_id=" . $taskId;
                    $media_tasks     = $general->get_Onerow("media_tasks", $vid_where);
                    $task[$key]['media_type']      = $media_tasks['media_type'];
                    $task[$key]['title_media']    = $media_tasks['title'];
                    $task[$key]['duration']    = $media_tasks['duration'];
                }
            }
            $data['tasks'] = $task;
            echo json_encode($data);
        }
        else
        {
            echo json_encode(['error' => 'No task found for the specified task_id']);
        }
    }
    else
    {
        echo json_encode(['error' => 'Missing user_id parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
