<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;
    $district_name = isset($_GET['district']) ? $_GET['district'] : null;

    if ($userId !== null && $district_name !== null) {
        $where = " and title='" . $district_name. "'";
        $district_details = $general->get_Onerow("districts", $where);

       

        if (!empty($district_details))
        {

            
            $where = " and id=" . $district_details['page_id'];

            $event_details = $general->get_Onerow("page", $where);

        $wheres = " and active='yes' and arena='yes' AND end_date >= NOW()"." and district_id=".$district_details['district_id']; // criteria for challenges
        $challenge_count = $general->get_AllRowscnt("challenges", $wheres);
        $challenge_arr = $general->get_AllRows("challenges", 0, $challenge_count, "created_date desc", $wheres);

        $data = array();
        $challenges = array();

        foreach ($challenge_arr as $val) {
            // Encode challenge details as JSON
            $challenge = array();
            $challenge['page_id'] = $val['page_id'];
            $challenge['challenge_id'] = $val['challenge_id'];
            $challenge['title'] = $val['title'];
            $challenge['description'] = $general->basedecode($val['description']);
            $challenge['challenge_type'] = $val['challenge_type'];
            $challenge['start_date'] = $val['start_date'];
            $challenge['start_time'] = $val['start_time'];
            $challenge['end_date'] = $val['end_date'];
            $challenge['end_time'] = $val['end_time'];
            $challenge['entry_points'] = $val['entry_points'];
            $challenge['reward_points'] = $val['reward_points'];
            $challenge['level'] = $val['level'];
            $challenge['created_by'] = $val['created_by'];
            $challenge['created_date'] = $val['created_date'];
            $challenge['participants_count'] = $val['participants_count'];
            $challenge['removed_date'] = $val['removed_date'];
            $challenge['removed_by'] = $val['removed_by'];

            $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id']);
            $page_details = $general->get_Onerow("page", "and id=" . $val['page_id']);
            $challenge['page_title'] = $district_details['title'];
            $challenge['icon'] = $district_details['image'];
            $user_challenges = $general->get_Onerow("user_challenges", " and challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId);
            $challenge['image'] = $challenge_media['media_path'];
            if ($user_challenges != "") { 
                $challenge["completed"] = "true";
            } else {
                $challenge["completed"] = "false";
            }

            $challenges[] = $challenge; // Append challenge to the array
        }

        // Sort challenges by created_date in descending order
        usort($challenges, function ($a, $b) {
            return strtotime($b['created_date']) - strtotime($a['created_date']);
        });

        $data['challenges'] = $challenges;

        echo json_encode($data);
    }
    } else {
        echo json_encode(['error' => 'Missing userId parameter']);
    }
} else {
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
