<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;

    $user_pages_cnt = $general->get_AllRowscnt("user_pages", " and user_id=" . $userId);
    $user_pages_rows = $general->get_AllRows("user_pages", 0, $user_pages_cnt, "id desc", " and user_id=" . $userId);

    $data = array();

    foreach ($user_pages_rows as $user_page) {
        $page_id = $user_page['page_id'];

        $posts = fetchPosts($general, $page_id);
        $challenges = fetchChallenges($general, $page_id, $userId);

        $data = array_merge($data, $posts, $challenges);
    }

    usort($data, function ($a, $b) {
        if (isset($a['created_date']) && isset($b['created_date'])) {
            return strtotime($b['created_date']) - strtotime($a['created_date']);
        } else {
            return 0;
        }
    });

    echo json_encode($data);
} else {
    echo json_encode(['error' => 'Invalid request method']);
}

function fetchPosts($general, $page_id)
{
    $where_posts = " and page_id=" . $page_id;
    $post_count = $general->get_AllRowscnt("posts", $where_posts);
    $posts = $general->get_AllRows("posts", 0, $post_count, "post_id desc", $where_posts);

    $data = array();

    foreach ($posts as $val) {
        $page_details = $general->get_Onerow("page", " and id=" . $val['page_id']);
        $post = array(
            'info_type' => 'post',
            'post_id' => $val['post_id'],
            'type' => $val['type'],
            'video' => $val['video'],
            'image' => $val['image'],
            'textData' => $val['textData'],
            'caption' => $val['caption'],
            'page_id' => $val['page_id'],
            'page_title' => $page_details['title'],
            'page_icon' => $page_details['icon'],
        );
        $data[] = $post;
    }

    return $data;
}

function fetchChallenges($general, $page_id, $userId)
{
    $where_challenges = " and active='yes' and page_id=" . $page_id;
    $challenge_count = $general->get_AllRowscnt("challenges", $where_challenges);
    $challenges = $general->get_AllRows("challenges", 0, $challenge_count, "created_date desc", $where_challenges);

    $data = array();

    foreach ($challenges as $val) {
        $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id']);
        $page_details = $general->get_Onerow("page", "and id=" . $val['page_id']);

        $user_challenges = $general->get_Onerow("user_challenges", "AND completed='yes'  and challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId);
        $challengeComplete = ($user_challenges != "") ? "true" : "false";

        $challenge = array(
            'info_type' => 'challenge',
            'challenge_id' => $val['challenge_id'],
            'title' => $val['title'],
            'description' => $general->basedecode($val['description']),
            'challenge_type' => $val['challenge_type'],
            'page_id' => $val['page_id'],
            'start_date' => $val['start_date'],
            'start_time' => $val['start_time'],
            'end_date' => $val['end_date'],
            'end_time' => $val['end_time'],
            'entry_points' => $val['entry_points'],
            'reward_points' => $val['reward_points'],
            'level' => $val['level'],
            'created_by' => $val['created_by'],
            'created_date' => $val['created_date'],
            'participants_count' => $val['participants_count'],
            'removed_date' => $val['removed_date'],
            'removed_by' => $val['removed_by'],
            'page_title' => $page_details['title'],
            'icon' => $page_details['icon'],
            'image' => $challenge_media['media_path'],
            'completed' => $challengeComplete,
        );
        $data[] = $challenge;
    }

    return $data;
}
?>
