<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;

    if ($userId !== null) {
        // Fetch pages that the user follows
        $where = " and user_id=" . $userId;
        $page_count = $general->get_AllRowscnt("user_pages", $where);

        $pages = $general->get_AllRows("user_pages", 0, $page_count, "id desc", $where);

        $data = array();
        $challenges = array();

        foreach ($pages as $page) {
            // Fetch challenges for each followed page
            $pageId = $page['page_id'];
            $wheres = " and active='yes' and arena='no' AND page_id = $pageId AND end_date >= NOW()";
            $challenge_count = $general->get_AllRowscnt("challenges", $wheres);
            $challenge_arr = $general->get_AllRows("challenges", 0, $challenge_count, "created_date desc", $wheres);
        
            foreach ($challenge_arr as $val) {
                // Encode challenge details as JSON
                $challenge = array();
                $challenge['page_id'] = $val['page_id'];
                $challenge['challenge_id'] = $val['challenge_id'];
                $challenge['title'] = $val['title'];
                $challenge['description'] = $general->basedecode($val['description']);
                $challenge['challenge_type'] = $val['challenge_type'];
                $challenge['start_date'] = $val['start_date'];
                $challenge['start_time'] = $val['start_time'];
                $challenge['end_date'] = $val['end_date'];
                $challenge['end_time'] = $val['end_time'];
                $challenge['entry_points'] = $val['entry_points'];
                $challenge['reward_points'] = $val['reward_points'];
                $challenge['level'] = $val['level'];
                $challenge['created_by'] = $val['created_by'];
                $challenge['created_date'] = $val['created_date'];
                $challenge['participants_count'] = $val['participants_count'];
                $challenge['removed_date'] = $val['removed_date'];
                $challenge['removed_by'] = $val['removed_by'];
        
                $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id']);
                $page_details = $general->get_Onerow("page", "and id=" . $val['page_id']);
                $challenge['page_title'] = $page_details['title'];
                $challenge['icon'] = $page_details['icon'];
                $user_challenges = $general->get_Onerow("user_challenges", " AND completed='yes' and challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId);
                $challenge['image'] = $challenge_media['media_path'];
                if ($user_challenges != "") {
                    $challenge["completed"] = "true";
                } else {
                    $challenge["completed"] = "false";
                }
        
                $challenges[] = $challenge; // Append challenge to the array
            }
        }
        

        // Sort challenges by created_date in descending order
        usort($challenges, function ($a, $b) {
            return strtotime($b['created_date']) - strtotime($a['created_date']);
        });

        $data['challenges'] = $challenges;

        echo json_encode($data);
    } else {
        echo json_encode(['error' => 'Missing userId parameter']);
    }
} else {
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
?>
