<?php
require_once("cors.php");
require_once("includes/general.class.php");
require_once "PHPMailer/mailconfig.php";

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST')
{
    // Check if mobile number is provided in the request
    $email = isset($_POST['email']) ? $_POST['email'] : null;

    if ($email !== null)
    {
        // Construct the WHERE clause for the query
        $subject       = " Test Us Mail";

        $message = '
        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Test Email</title>
            <style>
                body {
                    font-family: Arial, sans-serif;
                    background-color: #f4f4f4;
                    padding: 20px;
                }
                .container {
                    max-width: 600px;
                    margin: 0 auto;
                    background-color: #ffffff;
                    padding: 20px;
                    border-radius: 5px;
                    box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.1);
                }
                h1 {
                    color: #333333;
                }
                p {
                    color: #666666;
                }
            </style>
        </head>
        <body>
            <div class="container">
                <h1>This is a Test Email</h1>
                <p>Hello, this is a test email to demonstrate inline CSS styling in HTML.</p>
                <p>You can customize this template further as needed.Hi'.date('Y/m/d H:i').'!</p>
            </div>
        </body>
        </html>
        ';

        $mail->AddAddress($email, "Admin");
        $mail->Subject = $subject;
        $mail->MsgHTML($message);
        try {
            // Attempt to send the email
            $msg = $mail->Send();
            if ($msg) {
                echo json_encode(['success' => 'Email sent successfully']);
            } else {
                echo json_encode(['error' => 'Failed to send email']);
            }
        } catch (Exception $e) {
            echo json_encode(['error' => 'An error occurred: ' . $e->getMessage()]);
        }
        
    }
    else
    {
        echo json_encode(['error' => 'Missing mobile parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
