<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $challenge_id = isset($_GET['challenge_id']) ? $_GET['challenge_id'] : null;
    $task_id = isset($_GET['task_id']) ? $_GET['task_id'] : null;
    $userId = isset($_GET['user_id']) ? $_GET['user_id'] : null;
    $end_date = date('Y-m-d H:i:s');
    $end_time = date('H:i:s');

    if ($challenge_id !== null && $task_id !== null) {
        $challenge_id = intval($challenge_id);
        $task_id = intval($task_id);

        $where = " AND challenge_id=" . $challenge_id . " AND task_id =" . $task_id;
        $task_relation = $general->get_Onerow("task_relation", $where);
        if (!empty($task_relation)) {
            $data = array();
            $current_order = $task_relation['order_id'];
            $next_order = $current_order + 1;

            $data['next'] = "no";

            $wheres = " AND challenge_id=" . $challenge_id . "  AND order_id =" . $next_order;
            $next_relation = $general->get_Onerow("task_relation", $wheres);

            if ($next_relation != "")
            {
                $data['next'] = "yes";
                $order_info = array(
                    'challenge_id' => $next_relation['challenge_id'],
                    'relation_id' => $next_relation['relation_id'],
                    'task_id' => $next_relation['task_id'],
                    'order_id' => $next_relation['order_id'],
                );
                $task_id = $next_relation['task_id'];

                if ($task_id !== null)
                {
                    $where = " and task_id=" . $task_id;
                    $tasks = $general->get_Onerow("tasks", $where);

                    if (!empty($tasks))
                    {
                        $data['task_id'] = $tasks['task_id'];
                        $data['challenge_id'] = $tasks['challenge_id'];
                        $data['task_name'] = $tasks['task_name'];
                        $data['description'] = $general->basedecode($tasks['description']);
                        $data['start_date'] = $tasks['start_date'];
                        $data['start_time'] = $tasks['start_time'];
                        $data['end_date'] = $tasks['end_date'];
                        $data['end_time'] = $tasks['end_time'];
                        $data['task_type'] = $tasks['task_type'];
                        $data['verification_method'] = $tasks['verification_method'];
                        $data['entry_points'] = $tasks['entry_points'];
                        $data['reward_points'] = $tasks['reward_points'];
                        $data['reward_cash'] = $tasks['reward_cash'];
                        $data['verification_points'] = $tasks['verification_points'];
                        $data['is_certificate'] = $tasks['is_certificate'];
                        $data['is_badge'] = $tasks['is_badge'];
                        $data['player_level'] = $tasks['player_level'];
                        $data['created_date'] = $tasks['created_date'];
                        $data['created_by'] = $tasks['created_by'];
                        $data['participants_count'] = $tasks['participants_count'];
                        $data['active'] = $tasks['active'];
                        $data['removed_date'] = $tasks['removed_date'];
                        $data['removed_by'] = $tasks['removed_by'];

                        $rel_where = " and challenge_id=" . $task_id;
                        $task_relation = $general->get_Onerow("task_relation", $rel_where);
                        $taskId = $tasks['task_id'];

                        if ($task_relation != "")
                        {
                            $data['multiple'] = "yes";
                        }
                        else
                        {
                            $data['multiple'] = "no";
                        }
                     
                        if ($tasks['task_type'] == "stepCounter")
                        {
                            $ped_where = " and task_id=" . $taskId;
                            $task_pedometer     = $general->get_Onerow("task_pedometer", $ped_where);
                            $data['steps']      = $task_pedometer['steps'];
                            $data['direction']  = $task_pedometer['direction'];
                        }
                        if ($tasks['task_type'] == "mediaCapture")
                        {
                            $med_where = " and task_id=" . $taskId;
                            $media_tasks     = $general->get_Onerow("media_tasks", $med_where);
                            $data['media_type']         = $media_tasks['media_type'];
                            $data['title_media']        = $media_tasks['title'];
                        }
                        if ($tasks['task_type'] == "videoCapture")
                        {
                            $vid_where = " and task_id=" . $taskId;
                            $media_tasks     = $general->get_Onerow("media_tasks", $vid_where);
                            $data['media_type']      = $media_tasks['media_type'];
                            $data['title_media']    = $media_tasks['title'];
                            $data['duration']    = $media_tasks['duration'];
                        }
                    }
                }

                $data['order_info'] = $order_info;
            }

            echo json_encode($data);
        } else {
            echo json_encode(['error' => 'No task relation found for the specified challenge_id and task_id']);
        }
    } else {
        echo json_encode(['error' => 'Missing challenge_id or task_id parameter']);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}
?>
