<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST')
{
    $title          = $_POST['title'];
    $description    = $general->baseencode($_POST['description']);
    $start_date     = $_POST['start_date'];
    $end_date       = $_POST['end_date'];
    $active         = "yes";
    $type           = "movie";
    $password       = $_POST['password'];
    $imageFile      = $_FILES['imageFile'];  // Change $_POST to $_FILES to get the file data

    $start_date = date("Y-m-d H:i:s", strtotime($start_date));
    $end_date   = date("Y-m-d H:i:s", strtotime($end_date));
    if ($imageFile['error'] !== UPLOAD_ERR_OK)
    {
        echo json_encode(['error' => 'File upload failed']);
        exit();
    }
    // Check for any validations you need
    $password = $general->baseencode($password);
    $data = array();
    $upload = $general->upload_file("imageFile", "image", 'image', "photos");
    // Insert page data into the database

    if ($upload[1] != "")
    {
        $errors[] = $upload[1];
        // Handle errors as needed
        echo json_encode(['error' => $upload[1]]);
        exit();
    }
    else
    {
        // Image upload was successful
        $image_name = $upload[0];
        // Process further as needed
    }

    $msg = $general->ins_Row(
        'page',
        'title, description, start_date, end_date, icon, banner, active,  type, password',
        "'$title', '$description', '$start_date', '$end_date', '$image_name', '$image_name', '$active',  '$type', '$password'"
    );

    $pageId = $general->get_insetId();

    if (empty($msg))
    {
        $eventDetails = [
            'title' => $title,
            'description' => $description,
            'start_date' => $start_date,
            'end_date' => $end_date,
            'icon' => $image_name,
            'banner' => $image_name,
            'active' => $active,
            'type' => $type,
            'password' => $password,
            'id' => $pageId,
        ];

        // Successful page creation
        echo json_encode(['success' => true, 'page' => $eventDetails]);
    }
    else
    {
        // Event creation failed
        echo json_encode(['error' => $errors]);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
