<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    // Check if id is provided in the request
    $id = isset($_GET['page_id']) ? $_GET['page_id'] : null;
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;

    if ($id !== null && $userId !== null)
    {
        // Sanitize inputs
        $id = intval($id);
        $userId = intval($userId);

        // Check if the user is already following the page
        $follow_check = $general->get_Onerow("user_pages", "AND page_id=$id AND user_id=$userId");

        if ($follow_check)
        {
            // User is already following the page, unfollow
            $msg = $general->del_Row("user_pages", "id=" . $follow_check['id']);
            $details = $general->get_Onerow("page", " and id=" . $id);
            $new_follower_count = $details['followers'] - 1;
            $update_follow = $general->upd_Row("page", "followers=$new_follower_count", "id=$id");
        }
        else
        {
            // User is not following the page, follow
            $details = $general->get_Onerow("page", " and id=" . $id);

            if (!empty($details))
            {
                $type = $details['type'];
                $result = $general->ins_Row(
                    'user_pages',
                    'type, user_id, page_id,movie_id',
                    "'$type', '$userId', '$id', '$id'"
                );
                if ($result=="")
                {
                    $update_follow = $general->upd_Row("page", "followers='" . ($details['followers'] + 1) . "'", "id=" . $id);
                }
                else
                {
                    echo json_encode(['error' => 'Failed to follow page']);
                }
            }
            else
            {
                echo json_encode(['error' => 'Page or movie details not found']);
            }
        }
    }
    else
    {
        echo json_encode(['error' => 'Missing id parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
