<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;

    if ($userId !== null)
    {
        // Fetch pages that the user follows
        $wheres = " and user_id=" . $userId;
        function calculateTimeDuration($startDateTime, $endDateTime)
        {
            // Calculate the difference between start and end date times
            $interval = $startDateTime->diff($endDateTime);

            // Format the time difference
            $format = '';
            if ($interval->d > 0)
            {
                $format .= $interval->d . ' days ';
            }
            if ($interval->h > 0)
            {
                $format .= $interval->h . ' hrs ';
            }
            if ($interval->i > 0)
            {
                $format .= $interval->i . ' minutes ';
            }
            if ($interval->s > 0)
            {
                $format .= $interval->s . 's';
            }

            return $format;
        }
        function getUserRank($challengeId, $userId)
        {
            global $general;
            // Fetch all users participating in the challenge

            $challengeUsers = $general->get_AllRows(
                "user_challenges",
                0,
                0,
                "end_date, end_time", // Sorting by end date and time to calculate time taken
                "AND challenge_id = $challengeId AND completed='yes'"
            );

            // Calculate time taken by each user and store in an associative array
            $timeTaken = [];
            foreach ($challengeUsers as $user)
            {
                $endTime = new DateTime($user['end_date'] . ' ' . $user['end_time']);
                $startTime = new DateTime($user['start_date']); // Assuming start time is 00:00:00
                $timeDiff = $startTime->diff($endTime);
                $timeTaken[$user['user_id']] = $timeDiff->s + $timeDiff->i * 60 + $timeDiff->h * 3600 + $timeDiff->d * 86400;
            }

            // Sort users based on time taken in ascending order
            asort($timeTaken);

            // Find the rank of the target user
            $rank = 1;
            foreach ($timeTaken as $userId => $time)
            {
                if ($userId == $userId)
                {
                    break;
                }
                $rank++;
            }

            return $rank;
        }
        $data = array();
        $challenge = array();

        $achievements_count = $general->get_AllRowscnt("achievements", $wheres);

        if ($achievements_count > 0)
        {
            $user_chall_arr = $general->get_AllRows("achievements", 0, $achievements_count, "end_date desc", $wheres);

            foreach ($user_chall_arr as $key => $vals)
            {
                // Encode challenge details as JSON
                $val                            = $general->get_Onerow("challenges", "and challenge_id=" . $vals['challenge_id']);

                $challenge[$key]['page_id'] = $val['page_id'];
                $challenge[$key]['challenge_id'] = $val['challenge_id'];
                $challenge[$key]['title'] = $val['title'];
                $challenge[$key]['description'] =  $general->basedecode($val['description']);
                $challenge[$key]['challenge_type'] = $val['challenge_type'];
                $challenge[$key]['start_date'] = $val['start_date'];
                $challenge[$key]['start_time'] = $val['start_time'];
                $challenge[$key]['end_date'] = $val['end_date'];
                $challenge[$key]['end_time'] = $val['end_time'];
                $challenge[$key]['entry_points'] = $val['entry_points'];
                $challenge[$key]['reward_points'] = $val['reward_points'];
                $challenge[$key]['level'] = $val['level'];
                $challenge[$key]['created_by'] = $val['created_by'];
                $challenge[$key]['created_date'] = $val['created_date'];
                $challenge[$key]['participants_count'] = $val['participants_count'];
                $challenge[$key]['removed_date'] = $val['removed_date'];
                $challenge[$key]['removed_by'] = $val['removed_by'];
                $single_task_cnt   = $general->get_AllRowscnt("tasks", " and challenge_id=".$vals['challenge_id']);
                $challenge[$key]['open_for'] = $val['open_for'];
                if($single_task_cnt ==1)
                {
                    $challenge[$key]['single_task'] = "yes";
                }
                else
                {
                    $challenge[$key]['single_task'] = "no";

                }

                $people_media = $general->get_Onerow("people_media", "and challenge_id=" . $val['challenge_id'] . " and user_id=" . $userId);
                $challenge[$key]['uploaded_image'] = $people_media ? $people_media['image'] : "";
                $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id']);
                $page_details = $general->get_Onerow("page", "and id=" . $val['page_id']);
                $challenge[$key]['page_title'] = $page_details['title'];
                $challenge[$key]['icon'] = $page_details['icon'];

                $challenge[$key]['image'] = $challenge_media['media_path'];
                $challenge[$key]['earned_points'] = $vals['reward_points'];
                $challenge[$key]['arena'] = $val['arena'];


                // Example usage:
                $startDateTime = new DateTime($vals['start_date']);
                $endDateTime = new DateTime($vals['end_date']);


                $challenge[$key]['spend'] =  calculateTimeDuration($startDateTime, $endDateTime);
                $userRank = getUserRank($vals['challenge_id'], $userId);
                $challenge[$key]['user_rank'] = $userRank;
                $challengeId = $vals['challenge_id'];
                $achievementRow = $general->get_Onerow("achievements", "AND user_id = $userId AND challenge_id = $challengeId");
                if (!empty($achievementRow))
                {
                    $achieved = true;
                }
                else
                {
                    $achieved = false;
                }
                $challenge[$key]['achieved'] = $achieved ;
            }
        }

        $data['challenge'] = $challenge;




        echo json_encode(['success' => true, 'data' => $data]);
    }
    else
    {
        echo json_encode(['error' => 'Missing userId parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
