<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    // Check if task_id is provided in the request
    $ChallengeId = isset($_GET['challenge_id']) ? $_GET['challenge_id'] : null;
    $user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;

    if ($ChallengeId !== null)
    {
        $challenges_arr     = $general->get_Onerow("challenges", " and challenge_id=" . $ChallengeId);

        $data = array();
        $where = " and active='yes' and challenge_id=" . $ChallengeId;
        if (isset($user_id))
        {
            $user_tasks     = $general->get_Onerow("user_tasks", " and challenge_id=" . $ChallengeId." and user_id=".$user_id);

            if (empty($user_tasks) && $challenges_arr['frequency']=="bootcamp")
            {
                $where .= " and day=1";
            }
            elseif($challenges_arr['frequency']=="bootcamp")
            {
                $where2 = "user_id=".$user_id." AND challenge_id=".$ChallengeId;
                $latest_user_task = $general->getLatestRow("user_tasks", $where2, "id", 'DESC', 1);
                $total_task_cnt = $general->get_AllRowscnt("tasks", " AND day=".$latest_user_task['day']);
                $total_user_task_cnt = $general->get_AllRowscnt("user_tasks", " AND day=".$latest_user_task['day']);
                if($total_task_cnt > $total_user_task_cnt)
                {
                    $where .= " and day=".$latest_user_task['day'];
                }
                elseif($total_task_cnt == $total_user_task_cnt)
                {
                    
                    $latest_end_date = strtotime($latest_user_task['end_date']);
    
                    // Check if the end_date is before today's date
                    if ($latest_end_date < strtotime('today')) {
                        // If end_date is before today's date, user can see the next day's task
                        $next_day =$latest_user_task['day']+1;
                        $where .= " and day=".$next_day;
                    }
                    else{
                        $where .= " and day=".$latest_user_task['day'];
                    }
                }
            }
        }
        $task = array();
        $task_count = $general->get_AllRowscnt("tasks", $where);
        if ($task_count > 0)
        {
            $task_arr = $general->get_AllRows("tasks", 0, $task_count, "challenge_id desc", $where);

            foreach ($task_arr as $key => $val)
            {
                $task[$key]['page_id'] = $challenges_arr['page_id'];
                $task[$key]['task_id'] = $val['task_id'];
                $task[$key]['challenge_id'] = $val['challenge_id'];
                $task[$key]['task_name'] = $val['task_name'];
                $task[$key]['description'] = $general->basedecode($val['description']);
                $task[$key]['challenge_type'] = $challenges_arr['challenge_type'];
                $task[$key]['frequency'] = $challenges_arr['frequency'];
                $task[$key]['start_date'] = $val['start_date'];
                $task[$key]['start_time'] = $val['start_time'];
                $task[$key]['end_date'] = $val['end_date'];
                $task[$key]['end_time'] = $val['end_time'];
                $task[$key]['task_type'] = $val['task_type'];
                $task[$key]['verification_method'] = $val['verification_method'];
                $task[$key]['entry_points'] = $val['entry_points'];
                $task[$key]['reward_points'] = $val['reward_points'];
                $task[$key]['reward_cash'] = $val['reward_cash'];
                $task[$key]['verification_points'] = $val['verification_points'];
                $task[$key]['is_certificate'] = $val['is_certificate'];
                $task[$key]['is_badge'] = $val['is_badge'];
                $task[$key]['player_level'] = $val['player_level'];
                $task[$key]['created_date'] = $val['created_date'];
                $task[$key]['created_by'] = $val['created_by'];
                $task[$key]['participants_count'] = $val['participants_count'];
                $task[$key]['active'] = $val['active'];
                $task[$key]['removed_date'] = $val['removed_date'];
                $task[$key]['removed_by'] = $val['removed_by'];
                $taskId = $val['task_id'];


                $task_image_arr = $general->get_Onerow("task_media", "and task_id =" . $taskId);
                $task[$key]['image'] = $task_image_arr['media_path'];


                $rel_where = " and challenge_id=" . $ChallengeId;

                $task_relation = $general->get_Onerow("task_relation", $rel_where);

                if ($task_relation != "")
                {
                    $task[$key]['multiple'] = "yes";
                }
                else
                {
                    $task[$key]['multiple'] = "no";
                }
                // if ($val['task_type'] == "map")
                // {

                //     $where = " and task_id=" . $taskId;
                //     $tasksMaps = $general->get_Onerow("task_map", $where);

                //     // Include map-related information in the response
                //     $mapInfo = array(
                //         'map_id' => $tasksMaps['map_id'],
                //         'task_id' => $tasksMaps['task_id'],
                //         'challenge_id' => $tasksMaps['challenge_id'],
                //         'reach_distance' => $tasksMaps['reach_distance'],
                //         'latitude' => $tasksMaps['latitude'],
                //         'longitude' => $tasksMaps['longitude'],
                //         // ... (include other fields as needed)
                //     );

                //     $task[$key]['map_info'] = $mapInfo;
                // }
                if ($val['task_type'] == "stepCounter")
                {
                    $ped_where = " and task_id=" . $taskId;
                    $task_pedometer     = $general->get_Onerow("task_pedometer", $ped_where);
                    $task[$key]['steps']      = $task_pedometer['steps'];
                    $task[$key]['direction']  = $task_pedometer['direction'];
                }
                if ($val['task_type'] == "mediaCapture")
                {
                    $med_where = " and task_id=" . $taskId;
                    $media_tasks     = $general->get_Onerow("media_tasks", $med_where);
                    $task[$key]['media_type']      = $media_tasks['media_type'];
                    $task[$key]['title_media']  = $media_tasks['title'];
                }
                if ($val['task_type'] == "videoCapture")
                {
                    $vid_where = " and task_id=" . $taskId;
                    $media_tasks     = $general->get_Onerow("media_tasks", $vid_where);
                    $task[$key]['media_type']      = $media_tasks['media_type'];
                    $task[$key]['title_media']    = $media_tasks['title'];
                    $task[$key]['duration']    = $media_tasks['duration'];
                }
            }
            $data['tasks'] = $task;
            echo json_encode($data);
        }
        else
        {
            echo json_encode(['error' => 'No task found for the specified task_id']);
        }
    }
    else
    {
        echo json_encode(['error' => 'Missing challenge_id parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
