<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    // Count challenges where arena = 'yes'
    $challengesCount = $general->get_AllRowscnt("user_challenges", "AND arena = 'yes' AND completed='yes'");

    if ($challengesCount > 0) {
        // Fetch user challenges where arena = 'yes'
        $challenges = $general->get_AllRows("user_challenges", 0, $challengesCount, null, "AND arena = 'yes' AND completed='yes'");

        // Group challenges by user ID
        $userChallenges = [];
        foreach ($challenges as $challenge) {
            $userId = $challenge['user_id'];
            if (!isset($userChallenges[$userId])) {
                $userChallenges[$userId] = [];
            }
            $userChallenges[$userId][] = $challenge;
        }

        // Calculate total reward points for each user
        $userData = [];
        foreach ($userChallenges as $userId => $challenges) {
            $totalPoints = array_sum(array_column($challenges, 'reward_points'));
            
            // Query user details
            $userDetails = $general->get_Onerow("user_details", " and id = $userId");
            $firstCharCapitalized = ucfirst($userDetails['name'][0]);

            // Prepare user data
            $userData[] = [
                'id' => $userId,
                'name' => $userDetails['name'],
                'image' => $userDetails['image'],
                'total_points' => $totalPoints,
                'first_character' => $firstCharCapitalized,
            ];
        }

        // Sort users by total reward points in descending order
        usort($userData, function($a, $b) {
            return $b['total_points'] - $a['total_points'];
        });

        // Add ranking to user data
        foreach ($userData as $rank => &$user) {
            $user['ranking'] = $rank + 1;
        }

        echo json_encode(['success' => true, 'data' => $userData]);
    } else {
        echo json_encode(['success' => true, 'data' => []]); // Return empty data if no challenges found
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
