<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;

    // Get user_id values from user_follow table
    $wheres = " and followed_user=" . $userId;
    $user_follow_count = $general->get_AllRowscnt("user_follow", $wheres);
    $user_follow_rows = $general->get_AllRows("user_follow", 0, $user_follow_count, "id desc", $wheres);
    $user_ids = array();
    foreach ($user_follow_rows as $follow_row) {
        $user_ids[] = $follow_row['user_id'];
    }

    // Initialize an empty array to store data
    $data = array();

    // Iterate through each followed user
    foreach ($user_ids as $user_id) {
        // Fetch user's post count
        $where = " and user_id=" . $user_id;
        $people_count = $general->get_AllRowscnt("people_data", $where);

        // If user has posts
        if ($people_count > 0) {
            // Fetch people media
            $people_arr = $general->get_AllRows("people_data", 0, $people_count, "id desc", $where);

            // Iterate through each post
            foreach ($people_arr as $key => $val2) 
            {
                // Retrieve data from people_media only if it exists
                $val = $general->get_Onerow("people_media", " and people_data_id=" . $val2['id']);
                $count_comment = $general->get_AllRowscnt("comments", " and people_id=" . $val2['id']);


                $challenge_id =$val2['challenge_id'];
                $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $challenge_id);

                // Check if $val is not empty before accessing its properties
                if (!empty($val))
                {
                    $peopleCard[$key]['id'] = $val['id'];
                    $peopleCard[$key]['caption'] = $val['caption'];
                    $peopleCard[$key]['image'] = $val['image'];
                }
                else
                {
                    $peopleCard[$key]['image'] = $challenge_media['media_path'];

                }

                $people_id = $val2['id'];
    
                $page_id = $val2['page_id'];
    
                $peopleCard[$key]['date'] = date("M d, Y \a\\t g:i A", strtotime($val2['created_at']));
    
                $peopleCard[$key]['page_id'] = $val2['page_id'];
                $peopleCard[$key]['task_id'] = $val2['task_id'];
                $peopleCard[$key]['people_data_id'] = $val2['id'];
                $peopleCard[$key]['challenge_id'] = $val2['challenge_id'];
                $peopleCard[$key]['user_id'] = $val2['user_id'];
    
                $user_id = $val2['user_id'];
    
                $where = " and people_data_id=" . $val2['id'];
                $people_likes = $general->get_AllRowscnt("people_likes", $where);
    
                $wheres = " and id=" . $user_id;
                $user_details = $general->get_Onerow("user_details", $wheres);
                $peopleCard[$key]['name'] = $user_details['name'];
                $peopleCard[$key]['first_character'] = substr($user_details['name'], 0, 1);
                $peopleCard[$key]['user_image'] = $user_details['image'];
                $peopleCard[$key]['user_id'] = $user_details['id'];
                $peopleCard[$key]['like_count'] = isset($people_likes) ? $people_likes : 0;
                $peopleCard[$key]['comment_count'] = isset($count_comment) ? $count_comment : 0;

                $challengesDetails = $general->get_Onerow("challenges", " and challenge_id='" . $challenge_id . "'");
                if (strtotime($challengesDetails['end_date']) >= time())
                {
                    $peopleCard[$key]['complete'] = "no";
                }
                else
                {
                    $peopleCard[$key]['complete'] = "yes";
                }
                $peopleCard[$key]['challenge_title'] = $challengesDetails['title'];
                $page = $general->get_Onerow("page", " and id='" . $page_id . "'");
                $peopleCard[$key]['icon'] = $page['icon'];
                $peopleCard[$key]['page_title'] = $page['title'];
                $peopleCard[$key]['end_date'] = date('d-m-Y', strtotime($val2['created_at']));
            }

            // Assign data for this user to the main data array
            $data = array_merge($data, $peopleCard);
        }
    }

    // Sort data based on latest created date
    usort($data, function ($a, $b) {
        return strtotime($b['date']) - strtotime($a['date']);
    });

    // Output the final data in JSON format
    echo json_encode($data);
} else {
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
