<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;

    $user_pages_cnt = $general->get_AllRowscnt("user_pages", " and user_id=" . $userId);
    $user_pages_rows = $general->get_AllRows("user_pages", 0, $user_pages_cnt, "id desc", " and user_id=" . $userId);

    $data = array();

    $seenPostIds = [];
$seenChallengeIds = [];

foreach ($user_pages_rows as $user_page) {
    $page_id = $user_page['page_id'];
    
    // Fetch posts and add only new ones
    $posts = fetchPosts($general, $page_id);
    foreach ($posts as $post) {
        if (!in_array($post['post_id'], $seenPostIds)) {
            $data[] = $post;
            $seenPostIds[] = $post['post_id'];
        }
    }
    
    // Fetch challenges and add only new ones
    $challenges = fetchChallenges($general, $page_id, $userId);
    foreach ($challenges as $challenge) {
        if (!in_array($challenge['challenge_id'], $seenChallengeIds)) {
            $data[] = $challenge;
            $seenChallengeIds[] = $challenge['challenge_id'];
        }
    }
}

    echo json_encode($data);
}
else
{
    echo json_encode(['error' => 'Invalid request method']);
}

function fetchPosts($general, $page_id)
{
    $where_posts = " and page_id=" . $page_id;
    $post_count = $general->get_AllRowscnt("posts", $where_posts);
    $posts = $general->get_AllRows("posts", 0, $post_count, "post_id desc", $where_posts);

    $data = array();

    foreach ($posts as $val)
    {
        $page_details = $general->get_Onerow("page", " and id=" . $val['page_id']);
        $post_id = $val['post_id'];
        $page_id = $val['page_id'];
        $userId = isset($_GET['userId']) ? $_GET['userId'] : null;
        $count_comment = $general->get_AllRowscnt("post_comments", " and post_id=" . $post_id);

        $where          = " and page_id=" . $page_id . " and post_id=" . $post_id . " and user_id=" . $userId;
        $post_likes   = $general->get_AllRowscnt("post_likes", $where);
        if(empty($post_likes))
        {
            $already_liked = false;
        }else
        {
            $already_liked = true;
        }
        $post = array(
            'info_type' => 'post',
            'post_id' => $val['post_id'],
            'type' => $val['type'],
            'video' => $val['video'],
            'image' => $val['image'],
            'textData' => $general->basedecode($val['textData']),
            'caption' => $val['caption'],
            'page_id' => $val['page_id'],
            'page_title' => $page_details['title'],
            'page_icon' => $page_details['icon'],
            'like_count' => $val['like_count'],
            'comment_count' => $count_comment,
            'already_liked' => $already_liked,
            'created_at' => date('d-m-Y H:i:s', strtotime($val['created_at'])),
        );
        $data[] = $post;
    }

    return $data;
}

function fetchChallenges($general, $page_id, $userId)
{
    $where_challenges = " and frequency<>'quiz' and frequency<>'food' and frequency<>'experience' and open_for ='everyone' and arena='no' and visit='no' and active='yes' and page_id=" . $page_id;
    $challenge_count = $general->get_AllRowscnt("challenges", $where_challenges);
    $challenges = $general->get_AllRows("challenges", 0, $challenge_count, "created_date desc", $where_challenges);

    $data = array();

    foreach ($challenges as $val)
    {
        $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id']);
        $page_details = $general->get_Onerow("page", "and id=" . $val['page_id']);

        $user_challenges = $general->get_Onerow("user_challenges", "  AND challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId);
        $challengeComplete = ($user_challenges != "") ? "true" : "false";


        $challenge = array(
            'info_type' => 'challenge',
            'challenge_id' => $val['challenge_id'],
            'title' => $val['title'],
            'description' => $general->basedecode($val['description']),
            'challenge_type' => $val['challenge_type'],
            'page_id' => $val['page_id'],
            'start_date' => $val['start_date'],
            'rewards' => $val['rewards'],
            'start_time' => $val['start_time'],
            'end_date' => $val['end_date'],
            'end_time' => $val['end_time'],
            'entry_points' => $val['entry_points'],
            'reward_points' => $val['reward_points'],
            'level' => $val['level'],
            'created_by' => $val['created_by'],
            'created_date' => $val['created_date'],
            'participants_count' => $val['participants_count'],
            'removed_date' => $val['removed_date'],
            'removed_by' => $val['removed_by'],
            'frequency' => $val['frequency'],
            'page_title' => $page_details['title'],
            'icon' => $page_details['icon'],
            'image' => $challenge_media['media_path'],
            'completed' => $challengeComplete,
            'referral_count' => $val['referral_count'],
            'created_at' => date('d-m-Y H:i:s', strtotime($val['start_date'])),
            // Add necessary data not in $challenges array
            'user_referral_count' => $general->get_AllRowscnt("referral_history", " AND referrer_user = $userId"),
            'selectedTitle' => array(
                'title' => $page_details['title'],
                'image' => $page_details['icon']
            )
        );

        $challenge['open_for'] = $val['open_for'];
        $single_task_cnt   = $general->get_AllRowscnt("tasks", " and challenge_id=" . $val['challenge_id']);

        if ($single_task_cnt == 1)
        {
            $challenge['single_task'] = "yes";
        }
        else
        {
            $challenge['single_task'] = "no";
        }

        if($user_challenges=="")
        {
            $data[] = $challenge;
        }
    }

    return $data;
}
