<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    // Check if id is provided in the request
    $challenge_id = isset($_GET['challenge_id']) ? $_GET['challenge_id'] : null;
    $userId = isset($_GET['user_id']) ? $_GET['user_id'] : null;

    if ($challenge_id !== null)
    {

        $data = array();

        $where = " AND challenge_id=" . $challenge_id;
        $challenge_details =  $general->get_Onerow("challenges", $where);


        // Encode challenge details as JSON
        $data['page_id']                = $challenge_details['page_id'];
        $data['challenge_id']           = $challenge_details['challenge_id'];
        $data['title']                  = $challenge_details['title'];
        $data['description']            =  $general->basedecode($challenge_details['description']);
        $data['challenge_type']         = $challenge_details['challenge_type'];
        $data['start_date']             = $challenge_details['start_date'];
        $data['start_time']             = $challenge_details['start_time'];
        $data['end_date']               = $challenge_details['end_date'];
        $data['end_time']               = $challenge_details['end_time'];
        $data['entry_points']           = $challenge_details['entry_points'];
        $data['days'] = $challenge_details['days'];
        $data['reward_points']          = $challenge_details['reward_points'];
        $data['level']                  = $challenge_details['level'];
        $data['created_by']             = $challenge_details['created_by'];
        $data['created_date']           = $challenge_details['created_date'];
        $data['participants_count']     = $challenge_details['participants_count'];
        $data['removed_date']           = $challenge_details['removed_date'];
        $data['rewards']           = $challenge_details['rewards'];
        $data['removed_by']             = $challenge_details['removed_by'];
        $data['open_for'] = $challenge_details['open_for'];
        $single_task_cnt   = $general->get_AllRowscnt("tasks", " and challenge_id=".$challenge_details['challenge_id']);

        if($single_task_cnt ==1)
        {
            $data['single_task'] = "yes";
        }
        else
        {
            $data['single_task'] = "no";

        }
        $challenge_media                            = $general->get_Onerow("challenge_media", "and challenge_id=" . $challenge_details['challenge_id']);
        $user_challenges                            = $general->get_Onerow("user_challenges", " AND completed='yes' and challenge_id=" . $challenge_details['challenge_id'] . " and user_id =" . $userId);
        $data['image']                  = $challenge_media['media_path'];
        if ($user_challenges != "")
        {
            $data["completed"] = "true";
        }
        else
        {
            $data["completed"] = "false";
        }





        echo json_encode($data);
    }
    else
    {
        echo json_encode(['error' => 'Missing id parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
