<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    $challenge_id   = isset($_GET['challenge_id']) ? $_GET['challenge_id'] : null;
    $sort           = isset($_GET['sort']) ? $_GET['sort'] : null;

    $sort_by  = "id desc";

    if (isset($sort))
    {
        if ($sort == "latest")
        {
            $sort_by  = "id desc";
        }
        if ($sort == "likes")
        {
            $sort_by  = "like_count desc";
        }
    }

    $where = " and challenge_id=" . $challenge_id;
    $contest_count = $general->get_AllRowscnt("contest", $where);

    if ($contest_count > 0)
    {
        $contest_arr = $general->get_AllRows("contest", 0, $contest_count, $sort_by, $where);
        $data = array();

        foreach ($contest_arr as $key => $val)
        {

            $data[$key]['id'] = $val['id'];
            $data[$key]['page_id'] = $val['page_id'];
            $data[$key]['challenge_id'] = $val['challenge_id'];
            $data[$key]['user_id'] = $val['user_id'];
            $data[$key]['media_path'] = $val['media_path'];
            $data[$key]['task_id'] = $val['task_id'];
            $data[$key]['type'] = $val['type'];
            $data[$key]['date'] = date("M d, Y \a\\t g:i A", strtotime($val['createdAt']));

            $contest_id      = $val['id'];
            $challenge_id   = $val['challenge_id'];
            $page_id        = $val['page_id'];
            $task_id        = $val['task_id'];

            $where          = " and challenge_id=" . $challenge_id . " and task_id=" . $task_id. " and contest_id=" . $contest_id;
            $contest_likes   = $general->get_AllRowscnt("contest_likes", $where);


            $user_id = $val['user_id'];
            $wheres = " and id=" . $user_id;
            $user_details     = $general->get_Onerow("user_details", $wheres);
            $data[$key]['name'] = $user_details['name'];
            $data[$key]['first_character'] = substr($user_details['name'], 0, 1);
            $data[$key]['user_image']   = $user_details['image'];
            $data[$key]['user_id']      = $user_details['id'];
            $data[$key]['like_count'] = $contest_likes;
            $challengesDetails     = $general->get_Onerow("challenges", " and challenge_id='" . $challenge_id . "'");
            if (strtotime($challengesDetails['end_date']) >= time())
            {
                $data[$key]['complete'] = "no";
            }
            else
            {
                $data[$key]['complete'] = "yes";
            }
            $data[$key]['challenge_title'] = $challengesDetails['title'];
            $page     = $general->get_Onerow("page", " and id='" . $page_id . "'");
            $data[$key]['icon'] = $page['icon'];
            $data[$key]['page_title'] = $page['title'];
        }

        echo json_encode($data);
    }
    else
    {
        echo json_encode(['error' => 'No Data found']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
