<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    // Check if id is provided in the request
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;
    $challenge_ids = isset($_GET['challenge_id']) ? $_GET['challenge_id'] : null;

    if ($challenge_ids !== null)
    {
        $challenges_arr1 = $general->get_Onerow("challenges", "and challenge_id =" . $challenge_ids);
        $id = $challenges_arr1['page_id'];
        $where = " and id=" . $id;
        $event_details = $general->get_Onerow("page", $where);

        if (!empty($event_details))
        {
            $data = array();
            $data['title'] = $event_details['title'];
            $data['image'] = $event_details['icon'];

            $events_arr = $general->get_Onerow("page", "and id=" . $event_details['id']);
            $data['followers'] = $events_arr['followers'];
            $data['title'] = $events_arr['title'];
            $data['type'] = $events_arr['type'];
            $data['following'] = "false";

            $data['completed'] = "no";
            $data['first_time'] = "yes";
            $data['pending'] = "no";

            if (isset($_GET['userId']))
            {
                $follow_check = $general->get_Onerow("user_pages", "and page_id=" . $event_details['id'] . " and user_id=" . $_GET['userId']);
                if ($follow_check != "")
                {
                    $data['following'] = "true";
                }
            }

            $data['pageId'] = $event_details['id'];


            $challenges_arr = $general->get_Onerow("challenges", "and challenge_id=" . $challenge_ids);
            $user_challenges_arr = $general->get_Onerow("user_challenges", "and challenge_id=" . $challenge_ids . " and user_id=" . $userId);

            $data['challenges'] = array_values($challenges_arr);

            if (empty($user_challenges_arr))
            {
                $data['completed'] = "no";
                $data['first_time'] = "yes";
                $data['pending'] = "no";
            }
            else
            {
                $data['first_time'] = "no";
                $data['completed'] = "yes";
                $data['pending'] = "no";

                if ($user_challenges_arr['completed'] == "yes")
                {
                    $data['completed'] = "yes";
                }
                $where_task = " and challenge_id=" . $challenge_ids;
                $task_count   = $general->get_AllRowscnt("tasks", $where_task);
                $where_user_task = " and challenge_id=" . $challenge_ids . " and user_id=" . $userId;
                $task_user_count   = $general->get_AllRowscnt("user_tasks", $where_user_task);

                if ($task_count > $task_user_count)
                {
                    $data['completed'] = "no";
                    $data['pending'] = "no";
                }
            }
            $end_date = strtotime($challenges_arr['end_date']);
            $current_datetime = time();

            if ($end_date < $current_datetime)
            {
                $data['completed'] = "yes";
            }
            echo json_encode($data);
        }
        else
        {
            echo json_encode(['error' => 'No challenges found for the specified id']);
        }
    }
    else
    {
        echo json_encode(['error' => 'Missing id parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
