<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;
    $page_id = isset($_GET['page_id']) ? $_GET['page_id'] : null;

    if ($userId !== null)
    {
        // Calculate 5 minutes before the current time
        $fiveMinutesAgo = date('Y-m-d H:i:s', strtotime('+5 minutes'));
        $currentTime = date('Y-m-d H:i:s');

        // $wheres = " and frequency='quiz' and page_id=$page_id and active='yes' AND arena='no' AND start_date BETWEEN NOW() AND DATE_ADD(NOW(), INTERVAL 5 MINUTE) AND end_date >= NOW()";
        // $wheres = " and frequency='quiz' and page_id=$page_id and active='yes' AND arena='no' AND start_date <=NOW() AND end_date >= NOW()";
        // criteria for challenges
        $wheres = " and frequency='quiz' and page_id=$page_id and live='yes' and active='yes' AND arena='no' AND  end_date >= NOW()";

        $challenge_count = $general->get_AllRowscnt("challenges", $wheres);
        $challenge_arr = $general->get_AllRows("challenges", 0, $challenge_count, "created_date desc", $wheres);
        $where2 = " and id=" . $page_id;

        $page_info = $general->get_Onerow("page", $where2);

        $data = array();
        $challenges = array();

        foreach ($challenge_arr as $val)
        {
            // Encode challenge details as JSON
            $challenge = array();
            $challenge['page_id'] = $val['page_id'];
            $challenge['challenge_id'] = $val['challenge_id'];
            $challenge['title'] = $val['title'];
            $challenge['description'] =  $general->basedecode($val['description']);
            $challenge['challenge_type'] = $val['challenge_type'];
            $challenge['start_date'] = $val['start_date'];
            $challenge['start_time'] = $val['start_time'];
            $challenge['end_date'] = $val['end_date'];
            $challenge['end_time'] = $val['end_time'];
            $challenge['entry_points'] = $val['entry_points'];
            $challenge['frequency'] = $val['frequency'];
            $challenge['reward_points'] = $val['reward_points'];
            $challenge['level'] = $val['level'];
            $challenge['created_by'] = $val['created_by'];
            $challenge['created_date'] = $val['created_date'];
            $challenge['participants_count'] = $val['participants_count'];
            $challenge['removed_date'] = $val['removed_date'];
            $challenge['removed_by'] = $val['removed_by'];
            $challenge['rewards'] = $val['rewards'];
            $challenge['info_type'] = 'challenge';
            $challenge['days'] = $val['days'];
            $challenge['visit'] = $val['visit'];
            $challenge['live'] = $val['live'];
            $challenge['referral_count'] = $val['referral_count'];
            $challenge['user_referral_count'] = $general->get_AllRowscnt("referral_history", " AND referrer_user = $userId");
            $challenge['open_for'] = $val['open_for'];
            $challenge['questions'] = $val['questions'];

            $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id']);
            $page_details = $general->get_Onerow("page", "and id=" . $val['page_id']);
            $challenge['page_title'] = $page_details['title'];
            $challenge['icon'] = $page_details['icon'];
            $user_challenges = $general->get_Onerow("user_challenges", " AND challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId);
            $challenge['image'] = $challenge_media['media_path'];
            if ($user_challenges != "")
            {
                $challenge["completed"] = "true";
            }
            else
            {
                $challenge["completed"] = "false";
            }
            $questions_cnt = $general->get_AllRowscnt("questions", " and challenge_id=" . $val['challenge_id']);

            if ($questions_cnt > 0)
            {
                $sort = "RAND()";
                if ($val['live'] == "yes")
                {
                    $questions_cnt = $val['questions'];
                    $sort = "id desc";
                }
                $questions_arr = $general->get_AllRows("questions", 0, $questions_cnt, $sort, " and challenge_id=" . $val['challenge_id']);
                foreach ($questions_arr as $key => $val2)
                {
                    $challenge[$key]['type'] = $val2['type'];
                    $challenge[$key]['timer'] = $val2['timer'];
                    $challenge[$key]['video'] = $val2['video'];
                    $challenge[$key]['audio'] = $val2['audio'];
                    $challenge[$key]['live'] = $val['live'];
                    $challenge[$key]['challenge_id'] = $val2['challenge_id'];
                    $challenge[$key]['image'] = $val2['image'];
                    $challenge[$key]['question'] = $val2['question'];
                    if ($val['live'] == "yes")
                    {
                        $questions_cnt = $val['questions'];
                    }
                    $challenge[$key]['count_question'] = $questions_cnt;
                    $options_cnt = $general->get_AllRowscnt("answers", " and question_id=" . $val2['id']);
                    if ($options_cnt > 0)
                    {
                        $options_arr = $general->get_AllRows("answers", 0, $options_cnt, "", " and question_id=" . $val2['id']);
                        $options = array();
                        foreach ($options_arr as $option)
                        {
                            $options[] = array(
                                'answer_text' => $option['answer_text'],
                                'answer' => $option['answer']
                            );
                        }
                        $challenge[$key]['options'] = $options;
                    }
                }
            }

            $challenges[] = $challenge; // Append challenge to the array
        }

        // Sort challenges by created_date in descending order
        usort($challenges, function ($a, $b)
        {
            return strtotime($b['created_date']) - strtotime($a['created_date']);
        });

        $data['challenges'] = array_values($challenges);
        $data['state'] = $page_info['title'];

        echo json_encode($data);
    }
    else
    {
        echo json_encode(['error' => 'Missing userId parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
