<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    // Check if id is provided in the request
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;
    $page_id = isset($_GET['page_id']) ? $_GET['page_id'] : null;
    $current_district_id = isset($_GET['current_district_id']) ? $_GET['current_district_id'] : null;

    // Get the page details associated with the district
    $where = " and id=" . $page_id;
    $event_details = $general->get_Onerow("page", $where);

    // Construct data array with page details
    $data = array();
    $data['title'] = $event_details['title'];
    $data['image'] = $event_details['icon'];
    $data['followers'] = $event_details['followers'];
    $data['following'] = "true"; // Assuming the user is following the page by default
    $data['pageId'] = $event_details['id'];

    // Check if user is following the page
    if (isset($_GET['userId']))
    {
        $follow_check = $general->get_Onerow("user_pages", "and page_id=" . $page_id . " and user_id=" . $_GET['userId']);
        if ($follow_check == "")
        {
            $data['following'] = "false";
        }
    }

    // Get all districts inside the page_id
    $districts_within_page_cnt = $general->get_AllRowscnt("districts", " and page_id=" . $page_id);
    $districts_within_page = $general->get_AllRows("districts", 0, $districts_within_page_cnt, "", " and page_id=" . $page_id);

    // Initialize districts data array
    $districtsData = array();

    // Iterate over each district and fetch challenges
    foreach ($districts_within_page as $district)
    {
        $district_id = $district['district_id'];
        $wheres = " and active='yes' and arena='no' and page_id=" . $event_details['id'] . " and district_id=" . $district_id;
        $wheres .= " AND end_date >= NOW() and open_for='everyone'";
        $wheres .= " AND visit = 'yes'";

        $challenge_count = $general->get_AllRowscnt("challenges", $wheres);

        if ($challenge_count > 0)
        {
            $challenge_arr = $general->get_AllRows("challenges", 0, $challenge_count, "challenge_id desc", $wheres);

            $challenges_data = array();

            foreach ($challenge_arr as $key => $val)
            {
                // Encode challenge details as JSON
                $single_task_cnt   = $general->get_AllRowscnt("tasks", " and challenge_id=" . $val['challenge_id']);
                $open_for = $val['open_for'];
                if ($single_task_cnt == 1)
                {
                    $single_task = "yes";
                }
                else
                {
                    $single_task = "no";
                }
                $challenges_data[] = array(
                    'challenge_id' => $val['challenge_id'],
                    'title' => $val['title'],
                    'description' => $general->basedecode($val['description']),
                    'challenge_type' => $val['challenge_type'],
                    'start_date' => $val['start_date'],
                    'start_time' => $val['start_time'],
                    'visit' => $val['visit'],
                    'end_date' => $val['end_date'],
                    'end_time' => $val['end_time'],
                    'frequency' => $val['frequency'],
                    'entry_points' => $val['entry_points'],
                    'reward_points' => $val['reward_points'],
                    'level' => $val['level'],
                    'created_by' => $val['created_by'],
                    'created_date' => $val['created_date'],
                    'participants_count' => $val['participants_count'],
                    'removed_date' => $val['removed_date'],
                    'removed_by' => $val['removed_by'],
                    'days' => $val['days'],
                    'image' => $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id'])['media_path'],
                    'icon' => $event_details['icon'],
                    'open_for' => $open_for,
                    'single_task' => $single_task,
                    'page_title' => $event_details['title'],
                    'completed' => ($general->get_Onerow("user_challenges", " and challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId) != "") ? "true" : "false",
                    'finished' => ($general->get_Onerow("user_challenges", " and completed='yes' and challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId) != "") ? "true" : "false",
                    'selectedTitle' => array(
                        'title' => $event_details['title'],
                        'image' => $event_details['icon']
                    )
                );
               
            }
            // Sort challenges with completed ones going last
            usort($challenges_data, function ($a, $b)
            {
                if ($a['completed'] == $b['completed'])
                {
                    return 0;
                }
                return ($a['completed'] < $b['completed']) ? -1 : 1;
            });

            // Add challenges data to the main data array under the current district
            $districtsData[] = array(
                'district_id' => $district_id,
                'title' => $district['title'],
                'challenges' => $challenges_data
            );
        }
        else
        {
            // If no challenges found, still add the district entry with an empty array of challenges
            $districtsData[] = array(
                'district_id' => $district_id,
                'title' => $district['title'],
                'challenges' => []
            );
        }
    }

    // Sort districts so that the current district comes first
    usort($districtsData, function ($a, $b) use ($current_district_id)
    {
        if ($a['district_id'] == $current_district_id)
        {
            return -1;
        }
        elseif ($b['district_id'] == $current_district_id)
        {
            return 1;
        }
        return 0;
    });

    // Add districts data array to the main data array
    $data['districtsData'] = $districtsData;

    // Return JSON response
    echo json_encode($data);
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
