<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Check if id is provided in the request
    $district_name = isset($_GET['district']) ? $_GET['district'] : null;
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;
    $visit = isset($_GET['visit']) ? $_GET['visit'] : null;
    $india = isset($_GET['india']) ? $_GET['india'] : null;

    if ($district_name !== null) {
        $where = " and title='" . $district_name . "'";
        $district_details = $general->get_Onerow("districts", $where);

        if (!empty($district_details)) {
            $where = " and id=" . $district_details['page_id'];

            $event_details = $general->get_Onerow("page", $where);
            $data = array();
            $data['title'] = $event_details['title'];
            $data['image'] = $event_details['icon'];

            $page_info_id = $district_details['page_id'];
            $wheres = " and page_id=$page_info_id and visit='yes' and arena='no' AND end_date >= DATE_SUB(NOW(), INTERVAL 7 DAY)";

            // Get the count of completed challenges in the past 7 days
            $challenge_count = $general->get_AllRowscnt("user_challenges", $wheres);

            $events_arr = $general->get_Onerow("page", "and id=" . $event_details['id']);
            $data['followers'] = $events_arr['followers'];
            $data['title'] = $events_arr['title'];
            $data['following'] = "false";

            if (isset($_GET['userId'])) {
                $follow_check = $general->get_Onerow("user_pages", "and page_id=" . $event_details['id'] . " and user_id=" . $_GET['userId']);
                if ($follow_check != "") {
                    $data['following'] = "true";
                }
            }

            $data['pageId'] = $event_details['id'];
            $challenges = array();

            if ($challenge_count > 0) {
                // Retrieve the first 20 completed challenges in the past 7 days, ordered by most completed
                $challenge_arr = $general->get_AllRows("user_challenges", 0, 20, "challenge_id desc", $wheres);

                // Keep track of completed challenge IDs to avoid repeating challenges
                $completed_challenge_ids = array();

                foreach ($challenge_arr as $key => $val2) {
                    // Get the challenge details
                    $val = $general->get_Onerow("challenges", " and challenge_id=" . $val2['challenge_id']);

                    // Check if the challenge has already been included
                    if (!in_array($val['challenge_id'], $completed_challenge_ids)) {
                        // Add the challenge ID to the completed challenge IDs array
                        $completed_challenge_ids[] = $val['challenge_id'];

                        // Encode challenge details as JSON
                        $challenges[$key]['page_id'] = $val['page_id'];
                        $challenges[$key]['challenge_id'] = $val['challenge_id'];
                        $challenges[$key]['title'] = $val['title'];
                        $challenges[$key]['description'] = $general->basedecode($val['description']);
                        $challenges[$key]['challenge_type'] = $val['challenge_type'];
                        $challenges[$key]['start_date'] = $val['start_date'];
                        $challenges[$key]['start_time'] = $val['start_time'];
                        $challenges[$key]['end_date'] = $val['end_date'];
                        $challenges[$key]['end_time'] = $val['end_time'];
                        $challenges[$key]['frequency'] = $val['frequency'];
                        $challenges[$key]['entry_points'] = $val['entry_points'];
                        $challenges[$key]['reward_points'] = $val['reward_points'];
                        $challenges[$key]['level'] = $val['level'];
                        $challenges[$key]['created_by'] = $val['created_by'];
                        $challenges[$key]['created_date'] = $val['created_date'];
                        $challenges[$key]['participants_count'] = $val['participants_count'];
                        $challenges[$key]['removed_date'] = $val['removed_date'];
                        $challenges[$key]['removed_by'] = $val['removed_by'];
                        $challenges[$key]['days'] = $val['days'];
                        $challenges[$key]['visit'] = $val['visit'];
                        $challenges[$key]['open_for'] = $val['open_for'];
                        $single_task_cnt   = $general->get_AllRowscnt("tasks", " and challenge_id=".$val['challenge_id']);
            
                        if($single_task_cnt ==1)
                        {
                            $challenges[$key]['single_task'] = "yes";
                        }
                        else
                        {
                            $challenges[$key]['single_task'] = "no";
            
                        }
                        $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id']);
                        $user_challenges = $general->get_Onerow("user_challenges", " and challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId);
                        $user_challenges_com = $general->get_Onerow("user_challenges", " and completed='yes' and challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId);
                        $challenges[$key]['image'] = $challenge_media['media_path'];
                        $challenges[$key]['icon'] = $event_details['icon'];
                        $challenges[$key]['page_title'] = $district_details['title'];

                        if ($user_challenges != "") {
                            $challenges[$key]["completed"] = "true";
                        } else {
                            $challenges[$key]["completed"] = "false";
                        }
                        if ($user_challenges_com != "") {
                            $challenges[$key]["finished"] = "true";
                        } else {
                            $challenges[$key]["finished"] = "false";
                        }

                        $selectedTitle = array(
                            'title' => $event_details['title'],
                            'image' => $district_details['image'],
                        );
                        $challenges[$key]['selectedTitle'] = $selectedTitle;
                    }
                }
            }

            $data['image'] = $district_details['image'];
            usort($challenges, function ($a, $b) {
                if ($a['completed'] == $b['completed']) {
                    return 0;
                }
                return ($a['completed'] < $b['completed']) ? -1 : 1;
            });
            
            // Encode the sorted challenges array as JSON
            $data['data'] = array_values($challenges);


            echo json_encode($data);
        } else {
            echo json_encode(['error' => 'No challenges found for the specified id']);
        }
    } else {
        echo json_encode(['error' => 'Missing district name parameter']);
    }
} else {
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
