<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    $type = isset($_GET['type']) ? $_GET['type'] : null;
    $where = " and type='" . $type . "'"; // Use the modified type number in the query
    $instructions_count = $general->get_AllRowscnt("instructions", $where);
    $data = array();
    $instructions = array();

    if ($instructions_count > 0)
    {
        $instruction_arr = $general->get_AllRows("instructions", 0, $instructions_count, "id asc", $where);
        foreach ($instruction_arr as $val)
        {

            $ins = array();
            $ins['id'] = $val['id'];
            $ins['image'] = $val['image'];
            $ins['description'] = $general->basedecode($val['description']);
            $ins['type'] = $val['type'];
            $ins['title'] = $val['title'];

            $instructions[] = $ins; // Append challenge to the array
        }
        $data['data'] = array_values($instructions);

        echo json_encode($data);
    }
    else
    {
        echo json_encode(['error' => 'No data found']); // Adjust error message accordingly
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
