<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    // Check if id is provided in the request
    $challenge_id = isset($_GET['challenge_id']) ? $_GET['challenge_id'] : null;
    $ranking = 0;

    if ($challenge_id !== null)
    {
        $where = " AND completed='yes' and challenge_id=" . $challenge_id;
        $challenge_count = $general->get_AllRowscnt("user_challenges", $where);

        $challenges = array();
        if ($challenge_count > 0)
        {
            $challenge_arr = $general->get_AllRows("user_challenges", 0, $challenge_count, null, $where);

            // Function to calculate duration
            function calculateDuration($start, $end)
            {
                $startDateTime = new DateTime($start);
                $endDateTime = new DateTime($end);
                return $startDateTime->diff($endDateTime)->format('%R%a');
            }

            // Sort challenges by duration
            usort($challenge_arr, function ($a, $b)
            {
                return calculateDuration($a['start_date'], $a['end_date']) - calculateDuration($b['start_date'], $b['end_date']);
            });

            foreach ($challenge_arr as $key => $val)
            {
                $ranking++;

                $user_details = $general->get_Onerow("user_details", "and id=" . $val['user_id']);
                if ($user_details != "")
                {
                    $name = ucfirst($user_details['name']);
                    $challenges[$key]['name'] = $name;
                    $challenges[$key]['first_character'] = substr($name, 0, 1);
                }
                else
                {
                    $challenges[$key]['name'] = "[Deleted User]";
                    $challenges[$key]['first_character'] = "[D]";
                }
                $challenges[$key]['ranking'] = $ranking;
                $challenge_details = $general->get_Onerow("challenges", "and challenge_id=" . $val['challenge_id']);
                $challenges[$key]['points'] = $challenge_details['reward_points'];
                // Calculate time spent
                $startDateTime = new DateTime($val['start_date']);
                $endDateTime = new DateTime($val['end_date']);

                $timeSpent = $startDateTime->diff($endDateTime);

                // Get the time spent in days, hours, or minutes
                if ($timeSpent->d > 0)
                {
                    $challenges[$key]['time_spent'] = $timeSpent->d . " days";
                }
                elseif ($timeSpent->h > 0)
                {
                    $challenges[$key]['time_spent'] = $timeSpent->h . " hours";
                }
                else
                {
                    $challenges[$key]['time_spent'] = $timeSpent->i . " minutes";
                }
            }
        }
        $data['challenges'] = array_values($challenges);

        echo json_encode($data);
    }
    else
    {
        echo json_encode(['error' => 'Missing id parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
