<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;

    // Fetch follow requests for the user
    $followRequests_cnt = $general->get_AllRowscnt("follow_request", " and user_id=" . $userId);
    $followRequests = $general->get_AllRows("follow_request", 0, $followRequests_cnt, "created_at desc", " and user_id=" . $userId);

    // Fetch notifications for the user
    $notifications_cnt = $general->get_AllRowscnt(
        "notifications",
        " and seen='no' and user_id=$userId and (other_user <> $userId OR other_user IS NULL)"
    );

    $notifications_arr = $general->get_AllRows(
        "notifications",
        0,
        $notifications_cnt,
        "created_at desc",
        " and seen='no' and user_id=$userId and (other_user <> $userId OR other_user IS NULL)"
    );


    // Transform follow requests into notification format
    $notifications = array();
    if ($followRequests_cnt > 0)
    {
        foreach ($followRequests as $request)
        {
            $user_details = $general->get_Onerow("user_details", " and id=" . $request['followed_user']);

            $notification = array(
                'info_type' => 'follow_request',
                'request_id' => $request['id'],
                'user_id' => $request['user_id'],
                'followed_user' => $request['followed_user'],
                'created_at' => $request['created_at'],
                'name' => $user_details['name'],
                'first_character' => substr($user_details['name'], 0, 1),
                'user_image' => $user_details['image'],
            );
            $notifications[] = $notification;
        }
    }

    // Transform notifications into notification format
    if ($notifications_cnt > 0)
    {
        foreach ($notifications_arr as $notify)
        {

            $data = array();

            if ($notify['notification_type'] == "media_approved" || $notify['notification_type'] == "media_rejected")
            {

                $challenge_id = $notify['challenge_id'];
                $where = " AND challenge_id=" . $challenge_id;
                $challenge_details =  $general->get_Onerow("challenges", $where);


                // Encode challenge details as JSON
                $data['page_id']                = $challenge_details['page_id'];
                $data['challenge_id']           = $challenge_details['challenge_id'];
                $data['title']                  = $challenge_details['title'];
                $data['description']            =  $general->basedecode($challenge_details['description']);
                $data['challenge_type']         = $challenge_details['challenge_type'];
                $data['start_date']             = $challenge_details['start_date'];
                $data['start_time']             = $challenge_details['start_time'];
                $data['end_date']               = $challenge_details['end_date'];
                $data['end_time']               = $challenge_details['end_time'];
                $data['entry_points']           = $challenge_details['entry_points'];
                $data['days'] = $challenge_details['days'];
                $data['reward_points']          = $challenge_details['reward_points'];
                $data['level']                  = $challenge_details['level'];
                $data['created_by']             = $challenge_details['created_by'];
                $data['created_date']           = $challenge_details['created_date'];
                $data['participants_count']     = $challenge_details['participants_count'];
                $data['removed_date']           = $challenge_details['removed_date'];
                $data['removed_by']             = $challenge_details['removed_by'];
                $data['open_for'] = $challenge_details['open_for'];
                $single_task_cnt   = $general->get_AllRowscnt("tasks", " and challenge_id=" . $challenge_details['challenge_id']);

                if ($single_task_cnt == 1)
                {
                    $data['single_task'] = "yes";
                }
                else
                {
                    $data['single_task'] = "no";
                }
                $challenge_media                            = $general->get_Onerow("challenge_media", "and challenge_id=" . $challenge_details['challenge_id']);
                $user_challenges                            = $general->get_Onerow("user_challenges", " AND completed='yes' and challenge_id=" . $challenge_details['challenge_id'] . " and user_id =" . $userId);
                $data['image']                  = $challenge_media['media_path'];
                if ($user_challenges != "")
                {
                    $data["completed"] = "true";
                }
                else
                {
                    $data["completed"] = "false";
                }





                $notification = array(
                    'info_type' => $notify['notification_type'],
                    'notification_id' => $notify['notification_id'],
                    'user_id' => $notify['user_id'],
                    'content' => $notify['content'],
                    'read_status' => $notify['read_status'],
                    'additional_info' => $notify['additional_info'],
                    'post_id' => $notify['post_id'],
                    'page_id' => $notify['page_id'],
                    'other_user' => $notify['other_user'],
                    'created_at' => $notify['created_at'],
                    'challenge_id' => $notify['challenge_id'],
                    'people_id' => $notify['people_data_id'],
                    'challenge' => $data,
                );
            }
            else
            {
                $user_details = $general->get_Onerow("user_details", " and id=" . $notify['other_user']);
                $notification = array(
                    'info_type' => $notify['notification_type'],
                    'notification_id' => $notify['notification_id'],
                    'user_id' => $notify['user_id'],
                    'content' => $notify['content'],
                    'read_status' => $notify['read_status'],
                    'additional_info' => $notify['additional_info'],
                    'post_id' => $notify['post_id'],
                    'page_id' => $notify['page_id'],
                    'other_user' => $notify['other_user'],
                    'created_at' => $notify['created_at'],
                    'challenge_id' => $notify['challenge_id'],
                    'people_id' => $notify['people_data_id'],
                    'challenge' => $data,
                    'name' => $user_details['name'],
                    'first_character' => substr($user_details['name'], 0, 1),
                    'user_image' => $user_details['image'],
                );
            }


            $notifications[] = $notification;
        }
    }

    echo json_encode($notifications);
}
else
{
    echo json_encode(['error' => 'Invalid request method']);
}
