<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    // Check if id is provided in the request
    $id = isset($_GET['id']) ? $_GET['id'] : null;
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;

    if ($id !== null)
    {
        $where = " and id=" . $id;
        $movie_details = $general->get_Onerow("movie_details", $where);

        if (!empty($movie_details))
        {
            $data = array();
            $data['name'] = $movie_details['name'];
            $data['title'] = $movie_details['title'];
            $data['image'] = $movie_details['image'];

            $wheres = " and page_id=" . $movie_details['page_id'];
            $challenge_count = $general->get_AllRowscnt("challenges", $wheres);
            $events_arr = $general->get_Onerow("page", "and id=" . $movie_details['page_id']);
            $data['followers'] = $events_arr['followers'];
            $data['following'] = "false";

            if (isset($_GET['userId']))
            {
                $follow_check = $general->get_Onerow("user_pages", "and page_id=" . $movie_details['page_id'] . " and user_id=" . $_GET['userId']);
                if ($follow_check != "")
                {
                    $data['following'] = "true";
                }
            }

            $data['pageId'] = $movie_details['page_id'];

            if ($challenge_count > 0)
            {
                $challenge_arr = $general->get_AllRows("challenges", 0, $challenge_count, "challenge_id desc", $wheres);
                $challenges = array();

                foreach ($challenge_arr as $key => $val)
                {
                    // Encode challenge details as JSON
                    $challenges[$key]['page_id']               = $val['page_id'];
                    $challenges[$key]['challenge_id']           = $val['challenge_id'];
                    $challenges[$key]['title']                  = $val['title'];
                    $challenges[$key]['description']            = $val['description'];
                    $challenges[$key]['challenge_type']         = $val['challenge_type'];
                    $challenges[$key]['start_date']             = $val['start_date'];
                    $challenges[$key]['start_time']             = $val['start_time'];
                    $challenges[$key]['end_date']               = $val['end_date'];
                    $challenges[$key]['end_time']               = $val['end_time'];
                    $challenges[$key]['entry_points']           = $val['entry_points'];
                    $challenges[$key]['reward_points']          = $val['reward_points'];
                    $challenges[$key]['level']                  = $val['level'];
                    $challenges[$key]['created_by']             = $val['created_by'];
                    $challenges[$key]['created_date']           = $val['created_date'];
                    $challenges[$key]['participants_count']     = $val['participants_count'];
                    $challenges[$key]['removed_date']           = $val['removed_date'];
                    $challenges[$key]['removed_by']             = $val['removed_by'];

                    $challenge_media                            = $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id']);
                    $user_challenges                            = $general->get_Onerow("user_challenges", "and challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId);
                    $challenges[$key]['image']                  = $challenge_media['media_path'];
                    if ($user_challenges != "")
                    {
                        $challenges[$key]["completed"] = "true";
                    }
                    else
                    {
                        $challenges[$key]["completed"] = "false";
                    }
                }

                $data['challenges'] = $challenges;
            }

            echo json_encode($data);
        }
        else
        {
            echo json_encode(['error' => 'No movie found for the specified id']);
        }
    }
    else
    {
        echo json_encode(['error' => 'Missing id parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
