<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    // Check if task_id is provided in the request
    $ChallengeId    = isset($_GET['challenge_id']) ? $_GET['challenge_id'] : null;
    $task_id        = isset($_GET['task_id']) ? $_GET['task_id'] : null;

    if ($ChallengeId !== null)
    {
        $where = " and task_id=" . $task_id;
        $tasks = $general->get_Onerow("tasks", $where);

        if (!empty($tasks))
        {
            $data = array();
            $data['task_id'] = $tasks['task_id'];
            $data['challenge_id'] = $tasks['challenge_id'];
            $data['task_name'] = $tasks['task_name'];
            $data['description'] =  $general->basedecode($tasks['description']);
            $data['start_date'] = $tasks['start_date'];
            $data['start_time'] = $tasks['start_time'];
            $data['end_date'] = $tasks['end_date'];
            $data['end_time'] = $tasks['end_time'];
            $data['task_type'] = $tasks['task_type'];
            $data['verification_method'] = $tasks['verification_method'];
            $data['entry_points'] = $tasks['entry_points'];
            $data['reward_points'] = $tasks['reward_points'];
            $data['reward_cash'] = $tasks['reward_cash'];
            $data['verification_points'] = $tasks['verification_points'];
            $data['is_certificate'] = $tasks['is_certificate'];
            $data['is_badge'] = $tasks['is_badge'];
            $data['player_level'] = $tasks['player_level'];
            $data['created_date'] = $tasks['created_date'];
            $data['created_by'] = $tasks['created_by'];
            $data['participants_count'] = $tasks['participants_count'];
            $data['active'] = $tasks['active'];
            $data['removed_date'] = $tasks['removed_date'];
            $data['removed_by'] = $tasks['removed_by'];
            $taskId = $tasks['task_id'];
            $rel_where = " and challenge_id=" . $ChallengeId;
            $challenge_where = " and challenge_id=" . $tasks['challenge_id'];
            $media_where = " and task_id=" . $tasks['task_id'];
            $task_relation = $general->get_Onerow("task_relation", $rel_where);
            $challenge_arr = $general->get_Onerow("challenges", $challenge_where);
            $task_array = $general->get_Onerow("task_media", $media_where);
            $data['challenge_title'] = $challenge_arr['title'];
            $data['image'] = $task_array['media_path'];

            if ($task_relation != "")
            {
                $data['multiple'] = "yes";
            }
            else
            {
                $data['multiple'] = "no";
            }
            if ($tasks['task_type'] == "map")
            {

                $where = " and task_id=" . $taskId;
                $tasksMaps = $general->get_Onerow("task_map", $where);

                // Include map-related information in the response
                $mapInfo = array(
                    'map_id' => $tasksMaps['map_id'],
                    'task_id' => $tasksMaps['task_id'],
                    'challenge_id' => $tasksMaps['challenge_id'],
                    'reach_distance' => $tasksMaps['reach_distance'],
                    'latitude' => $tasksMaps['latitude'],
                    'longitude' => $tasksMaps['longitude'],
                    // ... (include other fields as needed)
                );

                $data['map_info'] = $mapInfo;
            }
            if ($tasks['task_type'] == "stepCounter")
            {
                $ped_where = " and task_id=" . $taskId;
                $task_pedometer     = $general->get_Onerow("task_pedometer", $ped_where);
                $data['steps']      = $task_pedometer['steps'];
                $data['direction']  = $task_pedometer['direction'];
            }
            if ($tasks['task_type'] == "mediaCapture")
            {
                $med_where = " and task_id=" . $taskId;
                $media_tasks     = $general->get_Onerow("media_tasks", $med_where);
                $data['media_type']      = $media_tasks['media_type'];
                $data['title_media']  = $media_tasks['title'];
            }
            if ($tasks['task_type'] == "videoCapture")
            {
                $vid_where = " and task_id=" . $taskId;
                $media_tasks     = $general->get_Onerow("media_tasks", $vid_where);
                $data['media_type']      = $media_tasks['media_type'];
                $data['title_media']    = $media_tasks['title'];
                $data['duration']    = $media_tasks['duration'];
            }

            echo json_encode($data);
        }
        else
        {
            echo json_encode(['error' => 'No task found for the specified task_id']);
        }
    }
    else
    {
        echo json_encode(['error' => 'Missing challenge_id parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
