<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    $user_id    = isset($_GET['user_id']) ? $_GET['user_id'] : null;
    $other_user = isset($_GET['other_user']) ? $_GET['other_user'] : null;

    $where              = " and id=" . $user_id;
    $user_details       = $general->get_Onerow("user_details", $where);
    if (
        $other_user
    )
    {
        $followed_check               = " and user_id=" . $other_user . " and followed_user=" . $user_id;
        $followed_check_user          = $general->get_Onerow("user_follow", $followed_check);
        $following_check               = " and followed_user=" . $other_user . " and user_id=" . $user_id;
        $following_check_user          = $general->get_Onerow("user_follow", $following_check);
        $following_request_check               = " and followed_user=" . $other_user . " and user_id=" . $user_id;
        $following_request_check_user          = $general->get_Onerow("follow_request", $following_request_check);
    }

    $follow_name = "Follow";
    $streak_day = "no";
    if ($user_details > 0)
    {
        $data = array();
        if (!empty($following_check_user) && !empty($followed_check_user))
        {
            $follow_name = "Friends";
        }
        elseif (!empty($following_check_user))
        {
            $follow_name = "Following";
        }
        elseif (!empty($followed_check_user))
        {
            $follow_name = "Follow Back";
        }

        if (!empty($following_request_check_user))
        {
            $follow_name = "Requested";
        }

        $lastLoginInfo = $general->getLatestRow("user_login", "user_id = $user_id", "login_date", "DESC", 1);
        if (!empty($lastLoginInfo))
        {
            $login_date = $lastLoginInfo['login_date'];
            $loginDateTime = new DateTime($login_date);
            $today = new DateTime(); // Current date and time
            $yesterday = (new DateTime())->modify('-1 day');
            if ($loginDateTime->format('Y-m-d') === $yesterday->format('Y-m-d'))
            {
                $streak_day = "yes";
            }
        }

        $xp_bank_data = $general->get_Onerow("xp_bank", " and user_id = $user_id and page_id=5");
        if($xp_bank_data=="")
        {
            $msg = $general->ins_Row(
                'xp_bank',
                ' user_id, total_xp, page_id',
                " '$user_id', '0', '5'"
            );
            if($msg=="")
            {
                $xp_bank_data = $general->get_Onerow("xp_bank", " and user_id = $user_id and page_id=5");

            }
        }
        $level = 1;
        $total_xp = 0;
        $this_level_xp = 0;
        $next_level_xp = 1;
        $percent_to_next_level = 0;
        if ($xp_bank_data)
        {
            $total_xp = $xp_bank_data['total_xp'];
            $level_data = $general->get_Onerow("level", " and $total_xp BETWEEN from_xp AND to_xp");
            $level = $level_data['level'];
            $this_level_xp = $level_data['from_xp'];
            $next_level_data = $general->get_Onerow("level", " and level = " . ($level + 1));
            $next_level_xp = $next_level_data['from_xp'];

            // Calculate percentage towards next level
            $xp_needed_for_next_level = $next_level_xp - $total_xp;
            $percent_to_next_level = intval(($total_xp / $next_level_xp) * 100);
        }

        $data['name']               = $user_details['name'];
        $data['first_character']    = substr($user_details['name'], 0, 1);
        $data['user_image']         = $user_details['image'];
        $data['user_id']            = $user_details['id'];
        $data['gender']             = $user_details['gender'];
        $data['mobile']             = $user_details['mobile'];
        $data['referral_id']        = $user_details['referral_id'];
        $data['account_status']     = $user_details['account_status'];
        $data['level']              = $level;
        $data['total_xp']           = $total_xp;
        $data['next_level']         = $level + 1;
        $data['this_level_xp']      = $this_level_xp;
        $data['next_level_xp']      = $next_level_xp;
        $data['percent_to_next_level']      = $percent_to_next_level;
        $data['progress']      = $percent_to_next_level / 100;
        $data['follow_name']      = $follow_name;
        $data['streak_day']      = $streak_day;

        $peopleCard = array();
        $user_id = $user_details['id'];
        $where = " and user_id=" . $user_id;
        $people_count = $general->get_AllRowscnt("people_data", $where);
        $userpost_count = $general->get_AllRowscnt("user_posts", $where);


        $data['post_count']          = $people_count;
        $where_friends = " and followed_user=" . $user_id . " OR following_user=" . $user_id;
        $friends_count = $general->get_AllRowscnt("friends", $where_friends);
        $data['friends_count']          = $friends_count;

        $wheres = " and followed_user=" . $user_id;
        $total_following_count = $general->get_AllRowscnt("user_follow", $wheres);
        $data['following']          = $total_following_count;
        $where2 = " and user_id=" . $user_id;
        $total_follower_count = $general->get_AllRowscnt("user_follow", $where2);
        $data['followers']          = $total_follower_count;
        if ($people_count > 0)
        {
            $people_arr = $general->get_AllRows("people_data", 0, $people_count, "id desc", $where);

            foreach ($people_arr as $key => $val2)
            {
                // Retrieve data from people_media only if it exists
                $val = $general->get_Onerow("people_media", " and people_data_id=" . $val2['id']);

                $count_comment = $general->get_AllRowscnt("comments", " and people_id=" . $val2['id']);

                $challenge_id = $val2['challenge_id'];
                $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $challenge_id);

                // Check if $val is not empty before accessing its properties
                if (!empty($val))
                {
                    $peopleCard[$key]['id'] = $val['id'];
                    $peopleCard[$key]['caption'] = $val['caption'];
                    $peopleCard[$key]['image'] = $val['image'];
                }
                else
                {
                    $peopleCard[$key]['image'] = $challenge_media['media_path'];

                }
                $people_id = $val2['id'];

                $page_id = $val2['page_id'];

                $peopleCard[$key]['date'] = date("M d, Y \a\\t g:i A", strtotime($val2['created_at']));

                $peopleCard[$key]['page_id'] = $val2['page_id'];
                $peopleCard[$key]['task_id'] = $val2['task_id'];
                $peopleCard[$key]['people_data_id'] = $val2['id'];
                $peopleCard[$key]['challenge_id'] = $val2['challenge_id'];
                $peopleCard[$key]['user_id'] = $val2['user_id'];
                $peopleCard[$key]['comment_count'] = isset($count_comment) ? $count_comment : 0;

                $user_id = $val2['user_id'];

                $where = " and people_data_id=" . $val2['id'];
                $people_likes = $general->get_AllRowscnt("people_likes", $where);

                $wheres = " and id=" . $user_id;
                $user_details = $general->get_Onerow("user_details", $wheres);
                $peopleCard[$key]['name'] = $user_details['name'];
                $peopleCard[$key]['first_character'] = substr($user_details['name'], 0, 1);
                $peopleCard[$key]['user_image'] = $user_details['image'];
                $peopleCard[$key]['user_id'] = $user_details['id'];
                $peopleCard[$key]['like_count'] = isset($people_likes) ? $people_likes : 0;

                $challengesDetails = $general->get_Onerow("challenges", " and challenge_id='" . $challenge_id . "'");
                if (strtotime($challengesDetails['end_date']) >= time())
                {
                    $peopleCard[$key]['complete'] = "no";
                }
                else
                {
                    $peopleCard[$key]['complete'] = "yes";
                }
                $peopleCard[$key]['challenge_title'] = $challengesDetails['title'];
                $page = $general->get_Onerow("page", " and id='" . $page_id . "'");
                $peopleCard[$key]['icon'] = $page['icon'];
                $peopleCard[$key]['page_title'] = $page['title'];
                $peopleCard[$key]['end_date'] = date('d-m-Y', strtotime($val2['created_at']));
            }
        }
        $data['peopleCard'] = $peopleCard;
        $UserCard = array();
        if ($userpost_count > 0)
        {
            $where = " and user_id=" . $user_id;

            $user_post_arr = $general->get_AllRows("user_posts", 0, $userpost_count, "id desc", $where);

            foreach ($user_post_arr as $key => $val)
            {
                // Retrieve data from people_media only if it exists

                $count_comment = $general->get_AllRowscnt("user_comments", " and post_id=" . $val['id']);



                $UserCard[$key]['id'] = $val['id'];
                $UserCard[$key]['textData'] = $general->basedecode($val['textData']);
                $UserCard[$key]['image'] = $val['image'];
                $UserCard[$key]['video'] = $val['video'];


                $UserCard[$key]['date'] = date("M d, Y \a\\t g:i A", strtotime($val['created_at']));

                $UserCard[$key]['post_id'] = $val['id'];
                $UserCard[$key]['user_id'] = $val['user_id'];
                $UserCard[$key]['comment_count'] = isset($count_comment) ? $count_comment : 0;

                $user_id = $val['user_id'];

                $where = " and post_id=" . $val['id'];
                $people_likes = $general->get_AllRowscnt("user_comment_likes", $where);

                $wheres = " and id=" . $user_id;
                $user_details = $general->get_Onerow("user_details", $wheres);
                $UserCard[$key]['name'] = $user_details['name'];
                $UserCard[$key]['first_character'] = substr($user_details['name'], 0, 1);
                $UserCard[$key]['user_image'] = $user_details['image'];
                $UserCard[$key]['user_id'] = $user_details['id'];
                $UserCard[$key]['like_count'] = isset($people_likes) ? $people_likes : 0;
                // $UserCard[$key]['challenge_title'] = $challengesDetails['title'];
                $UserCard[$key]['end_date'] = date('d-m-Y', strtotime($val['created_at']));
            }
        }
        $data['UserCard'] = $UserCard;

        echo json_encode($data);
    }
    else
    {
        echo json_encode(['error' => 'No Data found']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
