<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    $post_id = isset($_GET['post_id']) ? $_GET['post_id'] : null;
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;

    if ($post_id !== null)
    {
        // Correct the SQL query
        $wheres = " and parent_comment_id IS NULL AND post_id = $post_id";

        $post_comments_count = $general->get_AllRowscnt("post_comments", $wheres);
        $post_comments_arr = $general->get_AllRows("post_comments", 0, $post_comments_count, "created_at asc", $wheres);

        $data = array();

        if ($post_comments_count > 0)
        {
            foreach ($post_comments_arr as $key => $val)
            {
                $data[$key]['id'] = $val['id'];
                $data[$key]['parent_comment_id'] = $val['parent_comment_id'];
                $data[$key]['user_id'] = $val['user_id'];
                $data[$key]['post_id'] = $val['post_id'];
                $data[$key]['page_id'] = $val['page_id'];
                $data[$key]['sub_parent'] = $val['sub_parent'];
                $data[$key]['created_at'] = date('d-m-Y H:i:s', strtotime($val['created_at']));
                $id = $val['id'];
                $data[$key]['comment_text'] = $general->basedecode($val['comment_text']);
                $where_primary = " and id=" . $val['user_id'];
                $user_details     = $general->get_Onerow("user_details", $where_primary);
                $where_report    = " and reported_user=".$userId." and comment_id=".$val['id'];
                $reported     = $general->get_Onerow("report_post_comment", $where_report);
                $isReported = isset($reported) && !empty($reported) ? "yes" : "no";
                $data[$key]['name'] = $user_details['name'];
                $data[$key]['first_character'] = substr($user_details['name'], 0, 1);
                $data[$key]['user_image']   = $user_details['image'];
                $data[$key]['reported']   = $isReported;
                $data[$key]['post_comment_likes_count']   = $general->get_AllRowscnt("post_comment_likes", " and comment_id=".$val['id']);;
                $where          = " and comment_id=" . $val['id'] . " and  user_id=" . $userId;
                $post_comment_likes   = $general->get_AllRowscnt("post_comment_likes", $where);
                if(empty($post_comment_likes))
                {
                    $already_liked = false;
                }else
                {
                    $already_liked = true;
                }
                $data[$key]['already_liked']   = $already_liked;

                // Fetch replies for each comment
                $replies_cnt = $general->get_AllRowscnt("post_comments", " and parent_comment_id = $id");
                if ($replies_cnt > 0)
                {
                    $replies_arr = $general->get_AllRows("post_comments", 0, $replies_cnt, " created_at asc", " and parent_comment_id = $id");
                    $replies = array();
                    foreach ($replies_arr as $reply)
                    {
                        $where_secondary = " and id=" . $reply['user_id'];

                        $user_details2     = $general->get_Onerow("user_details", $where_secondary);
                        $where_report    = " and reported_user=".$userId." and comment_id=".$reply['id'];
                        $reported     = $general->get_Onerow("report_post_comment", $where_report);
                        $isReported = isset($reported) && !empty($reported) ? "yes" : "no";
                        $post_comment_likes_count   = $general->get_AllRowscnt("post_comment_likes", " and comment_id=".$reply['id']);;
                        $where          = " and comment_id=" . $reply['id'] . " and  user_id=" . $userId;
                        $post_comment_likes   = $general->get_AllRowscnt("post_comment_likes", $where);
                        if(empty($post_comment_likes))
                        {
                            $already_liked = false;
                        }else
                        {
                            $already_liked = true;
                        }
                        $replies[] = array(
                            'id' => $reply['id'],
                            'name' => $user_details2['name'],
                            'sub_parent' => $reply['sub_parent'],
                            'first_character' => substr($user_details2['name'], 0, 1),
                            'user_image' => $user_details2['image'],
                            'parent_comment_id' => $reply['parent_comment_id'],
                            'user_id' => $reply['user_id'],
                            'post_id' => $reply['post_id'],
                            'page_id' => $reply['page_id'],
                            'reported' => $isReported,
                            'post_comment_likes_count' => $post_comment_likes_count,
                            'already_liked' => $already_liked,
                            'created_at' => date('d-m-Y H:i:s', strtotime($reply['created_at'])),
                            'comment_text' => $general->basedecode($reply['comment_text']),
                        );
                    }
                    // Assign replies to the appropriate key in $data
                    $data[$key]['replies'] = $replies;
                }
            }

            echo json_encode($data);
        }
        else
        {
            echo json_encode(['error' => 'No data found']);
        }
    }
    else
    {
        echo json_encode(['error' => 'Missing post_id parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
