<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    // Check if user_id parameter is missing
    if (!isset($_GET['user_id']))
    {
        echo json_encode(['error' => 'user_id parameter is missing']);
        exit; // Stop execution
    }

    $user_id = $_GET['user_id'];

    // Check if there are any rows in user_details table
    $where_user = " and id<>" . $user_id;
    $user_count = $general->get_AllRowscnt("user_details", $where_user);
    // Check if there are any rows in page table
    $where_page = " and active='yes'";
    $page_count = $general->get_AllRowscnt("page", $where_page);

    // Check if count is not zero for either table
    if ($user_count > 0 || $page_count > 0)
    {
        // Fetch all rows from user_details and page tables
        $user_details = $general->get_AllRows("user_details", 0, $user_count, "id asc", $where_user);

        // Combine data from both tables into a single array
        $combined_data = array();

        // Process user details
        foreach ($user_details as $user)
        {
            $data = array();
            $data['type'] = 'user';
            $data['id'] = $user['id'];
            $data['user_id'] = $user['user_id'];
            $data['title'] = $user['name'];
            $data['image'] = $user['image'];
            // Other user-related fields can be added here
            $followed = $general->get_Onerow("user_follow", " and user_id=" . $user['id'] . " and followed_user=" . $user_id);
            if ($followed != "")
            {
                $data['following'] = "yes";
            }
            else
            {
                $data['following'] = "no";
            }
            $combined_data[] = $data;
        }

        // Process page details
        

        // Sorting combined data alphabetically by title
        usort($combined_data, function ($a, $b)
        {
            return strcmp($a['title'], $b['title']);
        });

        // Search functionality
        $search_query = isset($_GET['q']) ? $_GET['q'] : null;
        if ($search_query !== null)
        {
            $filtered_data = array_filter($combined_data, function ($item) use ($search_query)
            {
                return stripos($item['title'], $search_query) !== false;
            });
            $combined_data = array_values($filtered_data); // Reindex array after filtering
        }

        // Return combined data
        echo json_encode($combined_data);
    }
    else
    {
        echo json_encode(['error' => 'No data found']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
