<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    $id = isset($_GET['id']) ? $_GET['id'] : null;

    // Initialize an empty array to store data
    $data = array();

    // Fetch post data based on the provided ID
    $val2 = $general->get_Onerow("people_data", " and id=" . $id);

    if (!empty($val2)) {
        // Retrieve data from people_media only if it exists
        $val = $general->get_Onerow("people_media", " and people_data_id=" . $val2['id']);
        $count_comment = $general->get_AllRowscnt("comments", " and people_id=" . $val2['id']);
        $challenge_id =$val2['challenge_id'];
        $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $challenge_id);

        // Check if $val is not empty before accessing its properties
        if (!empty($val)) {
            $data['id'] = $val['id'];
            $data['caption'] = $val['caption'];
            $data['image'] = $val['image'];
        }
        else
        {
            $data['image'] = $challenge_media['media_path'];

        }

        // Extract relevant information from $val2
        $data['date'] = date("M d, Y \a\\t g:i A", strtotime($val2['created_at']));
        $data['page_id'] = $val2['page_id'];
        $data['task_id'] = $val2['task_id'];
        $data['people_data_id'] = $val2['id'];
        $data['challenge_id'] = $val2['challenge_id'];
        $data['user_id'] = $val2['user_id'];

        // Fetch user details
        $user_details = $general->get_Onerow("user_details", " and id=" . $val2['user_id']);
        $data['name'] = $user_details['name'];
        $data['first_character'] = substr($user_details['name'], 0, 1);
        $data['user_image'] = $user_details['image'];
        $data['user_id'] = $user_details['id'];

        // Fetch like count for this post
        $where = " and people_data_id=" . $val2['id'];
        $people_likes = $general->get_AllRowscnt("people_likes", $where);
        $data['like_count'] = isset($people_likes) ? $people_likes : 0;

        // Assign comment count for this post
        $data['comment_count'] = isset($count_comment) ? $count_comment : 0;

        // Determine if the challenge associated with this post is complete
        $challenge_id = $val2['challenge_id'];
        $challengesDetails = $general->get_Onerow("challenges", " and challenge_id='" . $challenge_id . "'");
        $data['complete'] = (strtotime($challengesDetails['end_date']) >= time()) ? "no" : "yes";
        $data['challenge_title'] = $challengesDetails['title'];

        // Fetch page details
        $page = $general->get_Onerow("page", " and id='" . $val2['page_id'] . "'");
        $data['icon'] = $page['icon'];
        $data['page_title'] = $page['title'];
        $data['end_date'] = date('d-m-Y', strtotime($val2['created_at']));
    }

    // Output the final data in JSON format
    echo json_encode($data);
} else {
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
?>
