<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;
    $challenge_id = isset($_GET['challenge_id']) ? $_GET['challenge_id'] : null;

    if ($challenge_id !== null)
    {


        $val = $general->get_Onerow("challenges", " and challenge_id=" . $challenge_id);

        $data = array();
        $challenges = array();


        // Encode challenge details as JSON
        $challenges['page_id'] = $val['page_id'];
        $challenges['challenge_id'] = $val['challenge_id'];
        $challenges['title'] = $val['title'];
        $challenges['description'] =  $general->basedecode($val['description']);
        $challenges['challenge_type'] = $val['challenge_type'];
        $challenges['start_date'] = $val['start_date'];
        $challenges['start_time'] = $val['start_time'];
        $challenges['end_date'] = $val['end_date'];
        $challenges['end_time'] = $val['end_time'];
        $challenges['entry_points'] = $val['entry_points'];
        $challenges['frequency'] = $val['frequency'];
        $challenges['reward_points'] = $val['reward_points'];
        $challenges['level'] = $val['level'];
        $challenges['created_by'] = $val['created_by'];
        $challenges['created_date'] = $val['created_date'];
        $challenges['participants_count'] = $val['participants_count'];
        $challenges['removed_date'] = $val['removed_date'];
        $challenges['removed_by'] = $val['removed_by'];
        $challenges['info_type'] = 'challenge';
        $challenges['days'] = $val['days'];
        $challenges['visit'] = $val['visit'];
        $challenges['live'] = $val['live'];
        $challenges['referral_count'] = $val['referral_count'];
        $challenges['user_referral_count'] = $general->get_AllRowscnt("referral_history", " AND referrer_user = $userId");
        $challenges['open_for'] = $val['open_for'];
        $config_app = $general->get_Onerow("config_app", " and id =1");
        $challenges['music'] = $config_app['music'];

        $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id']);
        $page_details = $general->get_Onerow("page", "and id=" . $val['page_id']);
        $challenges['page_title'] = $page_details['title'];
        $challenges['icon'] = $page_details['icon'];
        $user_challenges = $general->get_Onerow("user_challenges", " AND challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId);
        $challenges['image'] = $challenge_media['media_path'];
        if ($user_challenges != "")
        {
            $challenges["completed"] = "true";
        }
        else
        {
            $challenges["completed"] = "false";
        }
        $questions_cnt = $general->get_AllRowscnt("questions", " and challenge_id=" . $val['challenge_id']);

        if ($questions_cnt > 0)
        {
            $sort = "RAND()";
            if ($val['live'] == "yes")
            {
                $questions_cnt = $val['questions'];
                $sort = "id desc";
            }
            $questions_arr = $general->get_AllRows("questions", 0, $questions_cnt, $sort, " and challenge_id=" . $val['challenge_id']);
            foreach ($questions_arr as $key => $val2)
            {
                $challenges[$key]['type'] = $val2['type'];
                $challenges[$key]['timer'] = $val2['timer'];
                $challenges[$key]['video'] = $val2['video'];
                $challenges[$key]['audio'] = $val2['audio'];
                $challenges[$key]['live'] = $val['live'];
                $challenges[$key]['challenge_id'] = $val2['challenge_id'];
                $challenges[$key]['image'] = $val2['image'];
                $challenges[$key]['question'] = $val2['question'];
                if ($val['live'] == "yes")
                {
                    $questions_cnt = $val['questions'];
                }
                $challenges[$key]['count_question'] = $questions_cnt;
                $options_cnt = $general->get_AllRowscnt("answers", " and question_id=" . $val2['id']);
                if ($options_cnt > 0)
                {
                    $options_arr = $general->get_AllRows("answers", 0, $options_cnt, "", " and question_id=" . $val2['id']);
                    $options = array();
                    foreach ($options_arr as $option)
                    {
                        $options[] = array(
                            'answer_text' => $option['answer_text'],
                            'answer' => $option['answer']
                        );
                    }
                    $challenges[$key]['options'] = $options;
                }
            }
        }

        // Sort challenges by created_date in descending order


        $data['challenges'] = $challenges;
        $challenges['icon'] = $page_details['icon'];

        echo json_encode($data);
    }
    else
    {
        echo json_encode(['error' => 'Missing userId parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
