<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Check if id is provided in the request
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;
    $page_id = isset($_GET['page_id']) ? $_GET['page_id'] : null;

    $where = " and id=" . $page_id;

    $event_details = $general->get_Onerow("page", $where);
    $data = array();
    $data['title'] = $event_details['title'];
    $data['image'] = $event_details['icon'];

    $page_info_id = $page_id;
    $wheres = " and page_id=$page_id and visit='yes' and arena='no' AND end_date >= DATE_SUB(NOW(), INTERVAL 7 DAY)";

    // Get the count of completed challenges in the past 7 days
    $challenge_count = $general->get_AllRowscnt("user_challenges", $wheres);

    $events_arr = $general->get_Onerow("page", "and id=" . $event_details['id']);
    $data['followers'] = $events_arr['followers'];
    $data['title'] = $events_arr['title'];
    $data['following'] = "false";

    if (isset($_GET['userId'])) {
        $follow_check = $general->get_Onerow("user_pages", "and page_id=" . $event_details['id'] . " and user_id=" . $_GET['userId']);
        if ($follow_check != "") {
            $data['following'] = "true";
        }
    }

    $data['pageId'] = $event_details['id'];
    $challenges = array();

    if ($challenge_count > 0) {
        // Retrieve the first 20 completed challenges in the past 7 days, ordered by most completed
        $challenge_arr = $general->get_AllRows("user_challenges", 0, 20, "challenge_id desc", $wheres);

        // Keep track of completed challenge IDs to avoid repeating challenges
        $completed_challenge_ids = array();

        foreach ($challenge_arr as $key => $val2) {
            // Get the challenge details
            $val = $general->get_Onerow("challenges", " and challenge_id=" . $val2['challenge_id']);

            // Check if the challenge has already been included
            if (!in_array($val['challenge_id'], $completed_challenge_ids)) {
                // Add the challenge ID to the completed challenge IDs array
                $completed_challenge_ids[] = $val['challenge_id'];

                // Encode challenge details as JSON
                $challenge_details = array(
                    'page_id' => $val['page_id'],
                    'challenge_id' => $val['challenge_id'],
                    'title' => $val['title'],
                    'description' => $general->basedecode($val['description']),
                    'challenge_type' => $val['challenge_type'],
                    'start_date' => $val['start_date'],
                    'start_time' => $val['start_time'],
                    'end_date' => $val['end_date'],
                    'end_time' => $val['end_time'],
                    'frequency' => $val['frequency'],
                    'entry_points' => $val['entry_points'],
                    'reward_points' => $val['reward_points'],
                    'level' => $val['level'],
                    'created_by' => $val['created_by'],
                    'created_date' => $val['created_date'],
                    'participants_count' => $val['participants_count'],
                    'removed_date' => $val['removed_date'],
                    'removed_by' => $val['removed_by'],
                    'days' => $val['days'],
                    'visit' => $val['visit']
                );
                $challenge_details['open_for'] = $val['open_for'];
                $single_task_cnt   = $general->get_AllRowscnt("tasks", " and challenge_id=".$val['challenge_id']);
    
                if($single_task_cnt ==1)
                {
                    $challenge_details['single_task'] = "yes";
                }
                else
                {
                    $challenge_details['single_task'] = "no";
    
                }
                $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id']);
                $user_challenges = $general->get_Onerow("user_challenges", " and challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId);
                $challenge_details['image'] = $challenge_media['media_path'];
                $challenge_details['icon'] = $event_details['icon'];
                $challenge_details['page_title'] = $event_details['title'];
                $user_challenges_com = $general->get_Onerow("user_challenges", " and completed='yes' and challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId);
                if ($user_challenges != "") {
                    $challenge_details["completed"] = "true";
                } else {
                    $challenge_details["completed"] = "false";
                }
                if ($user_challenges_com != "") {
                    $challenge_details["finished"] = "true";
                } else {
                    $challenge_details["finished"] = "false";
                }
                $selectedTitle = array(
                    'title' => $event_details['title'],
                    'image' => $event_details['icon'],
                );
                $challenge_details['selectedTitle'] = $selectedTitle;

                // Add challenge details to the challenges array
                $challenges[] = $challenge_details;
            }
        }

        // Sort challenges with completed ones going last
        usort($challenges, function ($a, $b) {
            if ($a['completed'] == $b['completed']) {
                return 0;
            }
            return ($a['completed'] < $b['completed']) ? -1 : 1;
        });
    }

    $data['image'] = $event_details['icon'];
    $data['data'] = $challenges;

    echo json_encode($data);
} else {
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
?>
