<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (!isset($_GET['user_id']) || !isset($_GET['timeline']) || !isset($_GET['page_id'])) {
        echo json_encode(['error' => 'Missing required parameters']);
        exit;
    }

    $userId = intval($_GET['user_id']);
    $timeline = $_GET['timeline'];
    $pageId = intval($_GET['page_id']);

    $endDate = calculateEndDate($timeline);

    // Fetch count of challenges
    $challengesCount = $general->get_AllRowscnt("rewards_history", " AND end_date >= '$endDate' AND page_id = $pageId");
    $total_points = 0;

    if ($challengesCount > 0) {
        $challenges = $general->get_AllRows("rewards_history", 0, $challengesCount, "end_date ASC", " AND end_date >= '$endDate' AND page_id = $pageId");

        foreach ($challenges as $val) {
            if ($val['user_id'] == $userId) {
                $total_points += $val['reward_points'];
            }
        }
    }

    // Fetch total points of all users
    $usersPoints = [];
    foreach ($challenges as $val) {
        if (!isset($usersPoints[$val['user_id']])) {
            $usersPoints[$val['user_id']] = 0;
        }
        $usersPoints[$val['user_id']] += $val['reward_points'];
    }

    // Sort users based on total points
    arsort($usersPoints);

    // Find user's rank
    $rank = 1;
    foreach ($usersPoints as $user => $points) {
        if ($user == $userId) {
            break;
        }
        $rank++;
    }

    $userDetails = $general->get_Onerow("user_details", " AND id = $userId");
    if ($userDetails) {
        $firstCharCapitalized = ucfirst($userDetails['name'][0]);

        $userData = [
            'name' => $userDetails['name'],
            'image' => $userDetails['image'],
            'first_character' => $firstCharCapitalized,
            'user_id' => $userId,
            'total_points' => $total_points,
            'rank' => $rank
        ];

        echo json_encode(['success' => true, 'data' => $userData]);
    } else {
        echo json_encode(['error' => 'User not found']);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}

function calculateEndDate($timeline)
{
    $endDate = date('Y-m-d H:i:s');
    switch ($timeline) {
        case 'weekly':
            $endDate = date('Y-m-d H:i:s', strtotime('-1 week'));
            break;
        case 'monthly':
            $endDate = date('Y-m-d H:i:s', strtotime('-1 month'));
            break;
        case 'season':
            $endDate = date('Y-m-d H:i:s', strtotime('-4 months'));
            break;
        default:
            break;
    }
    return $endDate;
}
?>
