<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);

    $name = $_POST['name'] ?? null;
    $imageFile = $_FILES['imageFile'] ?? null;
    $latitude = $_POST['latitude'] ?? null;
    $longitude = $_POST['longitude'] ?? null;
    $phone = $_POST['phone'] ?? null;
    $firebase_id = $_POST['firebase_id'] ?? null;

    if (!$name || !$imageFile || !$latitude) {
        echo json_encode(['error' => 'Missing required fields']);
        exit();
    }

    if ($imageFile['error'] !== UPLOAD_ERR_OK) {
        echo json_encode(['error' => 'File upload failed']);
        exit();
    }

    $upload = $general->upload_file("imageFile", "image", 'image', "photos");
    if ($upload[1] != "") {
        echo json_encode(['error' => $upload[1]]);
        exit();
    }
    $image_name = $upload[0];


    $opened = "yes";

    $msg = $general->ins_Row(
        'stores',
        'name, image, latitude, longitude, phone, opened, firebase_id', // Correct order
        "'$name', '$image_name', '$latitude', '$longitude', '$phone', '$opened', '$firebase_id'"
    );
    
    $store_id = $general->get_insetId();


    if (empty($msg)) {
        $receivedData = [
            'id' => $store_id,
            'name' => $name,
            'latitude' => $latitude,
            'longitude' => $longitude,
            'phone' => $phone,
            'firebase_id' => $firebase_id
        ];
        echo json_encode(['success' => true, 'data' => $receivedData]);
    } else {
        echo json_encode(['error' => $msg]);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}
