<?php

require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST')
{
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    $user_id = $_POST['user_id'] ?? null;
    $caption = $_POST['caption'] ?? null;
    $imageFile = $_FILES['imageFile'] ?? null;
    $challenge_id = $_POST['challenge_id'] ?? null;
    $task_id = $_POST['task_id'] ?? null;
    $next = $_POST['next'] ?? null;

    if (!$user_id || !$caption || !$imageFile || !$challenge_id)
    {
        echo json_encode(['error' => 'Missing required fields']);
        exit();
    }

    if ($imageFile['error'] !== UPLOAD_ERR_OK)
    {
        echo json_encode(['error' => 'File upload failed']);
        exit();
    }

    $upload = $general->upload_file("imageFile", "image", 'image', "photos");

    if ($upload[1] != "")
    {
        echo json_encode(['error' => $upload[1]]);
        exit();
    }
    else
    {
        $image_name = $upload[0];
    }
    // $uploadedImagePath = ROOT_SITE . "/photos/" . $image_name;
    // $uploadedImage = imagecreatefromstring(file_get_contents($uploadedImagePath));

    // // Load the logo image
    // $logoPath = ROOT_SITE . "/photos/logo.png"; // Assuming logo.png is in the "photos" folder
    // $logo = imagecreatefrompng($logoPath);

    // imagesavealpha($logo, true);

    // // Get dimensions of the uploaded image and the logo
    // $uploadedImageWidth = imagesx($uploadedImage);
    // $uploadedImageHeight = imagesy($uploadedImage);
    // $logoWidth = imagesx($logo);
    // $logoHeight = imagesy($logo);

    // // Resize the logo to fit the uploaded image
    // $logoNewWidth = min($uploadedImageWidth / 4, $logoWidth);
    // $logoNewHeight = ($logoNewWidth / $logoWidth) * $logoHeight;

    // // Create a new image for the resized logo
    // $logoResized = imagecreatetruecolor($logoNewWidth, $logoNewHeight);
    // imagecopyresampled($logoResized, $logo, 0, 0, 0, 0, $logoNewWidth, $logoNewHeight, $logoWidth, $logoHeight);

    // // Calculate the position to place the logo (bottom-right corner with some padding)
    // $padding = 10;
    // $positionX = $uploadedImageWidth - $logoNewWidth - $padding;
    // $positionY = $uploadedImageHeight - $logoNewHeight - $padding;

    // // Merge the resized logo onto the uploaded image
    // imagecopy($uploadedImage, $logoResized, $positionX, $positionY, 0, 0, $logoNewWidth, $logoNewHeight);

    // // Save the image with the watermark
    // imagepng($uploadedImage, $uploadedImagePath);

    // // Free memory
    // imagedestroy($uploadedImage);
    // imagedestroy($logo);
    // imagedestroy($logoResized);

    $wheres = " and challenge_id=" . $challenge_id;
    $challenge = $general->get_Onerow("challenges", $wheres);

    $page_id = $challenge['page_id'];
    $cert_where = " and challenge_id=" . $challenge_id . " and task_id=" . $task_id . " and user_id=" . $user_id;
    $people_arr = $general->get_Onerow("people_data", $cert_where);

    if (empty($people_arr))
    {
        $msg = $general->ins_Row(
            'people_data',
            'user_id, task_id, challenge_id, page_id',
            "'$user_id', '$task_id', '$challenge_id', '$page_id'"
        );
        $people_data_id = $general->get_insetId();

        $msg = $general->ins_Row(
            'people_media',
            'caption, user_id, image, challenge_id, page_id, people_data_id, task_id,status',
            "'$caption', '$user_id', '$image_name', '$challenge_id', '$page_id', '$people_data_id', '$task_id'"
        );
    }
    else
    {
        $people_data_id = $people_arr['id'];
        $msg = $general->ins_Row(
            'people_media',
            'caption, user_id, image, challenge_id, page_id, people_data_id, task_id',
            "'$caption', '$user_id', '$image_name', '$challenge_id', '$page_id', '$people_data_id', '$task_id'"
        );
    }

    if ($challenge['visit'] == "yes" || $next == "no")
    {
        $end_date = date('Y-m-d H:i:s'); // Example: set end date to 1 week from now
        $cert_where = " and challenge_id=" . $challenge_id . " and task_id=" . $task_id . " and user_id=" . $user_id;
        $certificates_arr = $general->get_Onerow("certificates", $cert_where);

        if (empty($certificates_arr))
        {
            $active = "active";
            $msg4 = $general->ins_Row(
                'certificates',
                'challenge_id, page_id, user_id, end_date, people_data_id, task_id,status',
                "'$challenge_id', '$page_id', '$user_id', '$end_date', '$people_data_id', '$task_id', '$active'"
            );
            if (empty($msg4))
            {
                echo json_encode(['success' => true]);
            }
            else
            {
                echo json_encode(['error' => $msg4]);
            }
        }
        else
        {
            $certificate_id = $certificates_arr['id'];
            $active = "active";

            $msg4 = $general->upd_Row("certificates", "status='$active'", "id=$certificate_id");
        }
    }
    else
    {
        if (empty($msg))
        {
            echo json_encode(['success' => true]);
        }
        else
        {
            echo json_encode(['error' => $msg]);
        }
    }
}
else
{
    echo json_encode(['error' => 'Invalid request method']);
}
