<?php

require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $task_id = $_POST['taskId'] ?? null;
    $user_id = $_POST['userSId'] ?? null;
    $userTaskId = $_POST['userTaskId'] ?? null;
    $imageFile = $_FILES['imageFile'] ?? null;
    $challenge_id = $_POST['challenge_id'] ?? null;
    $media_type = $_POST['media_type'] ?? null;

    if (!$task_id || !$user_id || !$userTaskId || !$imageFile || !$challenge_id || !$media_type) {
        echo json_encode(['error' => 'Missing required fields']);
        exit();
    }

    if ($imageFile['error'] !== UPLOAD_ERR_OK) {
        echo json_encode(['error' => 'File upload failed']);
        exit();
    }

    $upload = ($media_type == "photo") ? 
              $general->upload_file("imageFile", "image", 'image', "photos") :
              $general->upload_file("imageFile", "video", 'video', "videos");

    if ($upload[1] != "") {
        echo json_encode(['error' => $upload[1]]);
        exit();
    } else {
        $image_name = $upload[0];
    }

    $end_date = date('Y-m-d H:i:s');
    $end_time = date('H:i:s');
    $yes = "yes";
    $no = 'no';

    $msg = $general->upd_Row("user_tasks", "end_date='$end_date', approved='$no', completed='$yes', end_time='$end_time'", "id=$userTaskId");
if($media_type == "photo")
{
    $msg = $general->upd_Row("user_tasks", "image='$image_name'", "id=$userTaskId");
}
else{
    $msg = $general->upd_Row("user_tasks", "video='$image_name'", "id=$userTaskId");
}
    

    

    if (empty($msg)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['error' => $msg]);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}
