<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Sanitize input to prevent SQL injection
    $post_id = isset($_POST['post_id']) ? intval($_POST['post_id']) : null;
// print_r($_POST);exit;
    if ($post_id !== null) {
        $where = " and post_id=" . $post_id;

        $post_arr = $general->get_Onerow("posts", $where);
        $data = array();

        if ($post_arr) {
            if ($post_arr['type'] == "image") {
                $photo = $post_arr['image'];
                $photo_path = "../../photos/" . stripslashes($photo);
                if (file_exists($photo_path)) {
                    // Handle potential errors during file deletion
                    if (unlink($photo_path)) {
                        $data['photo_deleted'] = true;
                    } else {
                        $data['photo_deleted'] = false;
                    }
                }
            }
            if ($post_arr['type'] == "video") {
                $video = $post_arr['video'];
                $video_path = "../../videos/" . stripslashes($video);
                if (file_exists($video_path)) {
                    // Handle potential errors during file deletion
                    if (unlink($video_path)) {
                        $data['video_deleted'] = true;
                    } else {
                        $data['video_deleted'] = false;
                    }
                }
            }

            // Delete the post from the database
            $general->del_Row("posts", "post_id = $post_id");
            $data['post_deleted'] = true;
        } else {
            $data['error'] = "Post not found";
        }
    } else {
        $data['error'] = "Invalid post ID";
    }

    echo json_encode($data);
} else {
    // Invalid request method
    header("HTTP/1.1 405 Method Not Allowed");
    echo json_encode(['error' => 'Invalid request method']);
}
?>
