<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    
    $pageId = $_GET['id'] ?? null;

    $where = " and page_id =$pageId";

    $districts_count = $general->get_AllRowscnt("districts", $where);

    if ($districts_count > 0)
    {
        $districts_arr = $general->get_AllRows("districts", 0, $districts_count, "title asc", $where);
        $data = array();

        foreach ($districts_arr as $key => $val)
        {
            $data[$key]['district_id'] = $val['district_id'];
            $data[$key]['title'] = $val['title'];
            $data[$key]['description'] =  $general->basedecode($val['description']);
            $data[$key]['image'] = $val['image'];
            $data[$key]['page_id'] = $val['page_id'];

            // Add other fields as needed
        }

        echo json_encode($data);
    }
    else
    {
        echo json_encode(['error' => 'No districts found']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
