<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    // Check if id is provided in the request
    $page_id        = isset($_GET['page_id']) ? $_GET['page_id'] : null;

    if ($page_id !== null)
    {

        $data = array();

        $where = " and active='yes' AND visit='no' and arena='no' AND page_id=" . $page_id;

        $challenge_count = $general->get_AllRowscnt("challenges", $where);

        if ($challenge_count > 0)
        {
            $challenge_details = $general->get_AllRows("challenges", 0, $challenge_count, "challenge_id desc", $where);

            foreach ($challenge_details as $key => $val)
            {
                // Encode challenge details as JSON
                $data[$key]['page_id']                = $val['page_id'];
                $data[$key]['challenge_id']           = $val['challenge_id'];
                $data[$key]['title']                  = $val['title'];
                $data[$key]['description']            =  $general->basedecode($val['description']);
                $data[$key]['challenge_type']         = $val['challenge_type'];
                $data[$key]['start_date']             = $val['start_date'];
                $data[$key]['frequency']             = $val['frequency'];
                $data[$key]['start_time']             = $val['start_time'];
                $data[$key]['end_date']               = $val['end_date'];
                $data[$key]['end_time']               = $val['end_time'];
                $data[$key]['entry_points']           = $val['entry_points'];
                $data[$key]['reward_points']          = $val['reward_points'];
                $data[$key]['level']                  = $val['level'];
                $data[$key]['created_by']             = $val['created_by'];
                $data[$key]['created_date']           = $val['created_date'];
                $data[$key]['participants_count']     = $val['participants_count'];
                $data[$key]['removed_date']           = $val['removed_date'];
                $data[$key]['removed_by']             = $val['removed_by'];
                $data['open_for'] = $val['open_for'];
                $single_task_cnt   = $general->get_AllRowscnt("tasks", " and challenge_id=" . $val['challenge_id']);

                if ($single_task_cnt == 1)
                {
                    $data['single_task'] = "yes";
                }
                else
                {
                    $data['single_task'] = "no";
                }

                $challenge_media                            = $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id']);
                $data[$key]['image']                  = $challenge_media['media_path'];
            }

            echo json_encode($data);
        }
        else
        {
            echo json_encode(['error' => 'No challenge found']);
        }
    }

    else
    {
        echo json_encode(['error' => 'Missing  parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
