<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;

    // Get user_id values from user_follow table
    $wheres = " and followed_user=" . $userId;
    $user_follow_count = $general->get_AllRowscnt("user_follow", $wheres);
    $user_follow_rows = $general->get_AllRows("user_follow", 0, $user_follow_count, "id desc", $wheres);
    $user_ids = array();
    foreach ($user_follow_rows as $follow_row) {
        $user_ids[] = $follow_row['user_id'];
    }

    // Initialize an empty array to store data
    $data = array();

    // Iterate through each followed user
    foreach ($user_ids as $user_id) {
        // Fetch user's post count
        $where = " and user_id=" . $user_id;
        $people_count = $general->get_AllRowscnt("people_media", $where);

        // If user has posts
        if ($people_count > 0) {
            // Fetch people media
            $people_arr = $general->get_AllRows("people_media", 0, $people_count, "createdAt desc", $where);

            // Iterate through each post
            foreach ($people_arr as $key => $val) {
                // Fetch details of the post
                $peopleCard[$key]['id'] = $val['id'];
                $peopleCard[$key]['page_id'] = $val['page_id'];
                $peopleCard[$key]['challenge_id'] = $val['challenge_id'];
                $peopleCard[$key]['user_id'] = $val['user_id'];
                $peopleCard[$key]['caption'] = $val['caption'];
                $peopleCard[$key]['image'] = $val['image'];
                $peopleCard[$key]['date'] = date("M d, Y \a\\t g:i A", strtotime($val['createdAt']));

                // Fetch user details
                $wheres = " and id=" . $val['user_id'];
                $user_details = $general->get_Onerow("user_details", $wheres);

                // Assign user details to the post
                $peopleCard[$key]['name'] = $user_details['name'];
                $peopleCard[$key]['first_character'] = substr($user_details['name'], 0, 1);
                $peopleCard[$key]['user_image'] = $user_details['image'];
                $peopleCard[$key]['user_id'] = $user_details['id'];

                // Fetch likes count for the post
                $where = " and challenge_id=" . $val['challenge_id'] . " and people_id=" . $val['id'];
                $people_likes = $general->get_AllRowscnt("people_likes", $where);
                $peopleCard[$key]['like_count'] = $people_likes;

                // Fetch challenge details
                $challengesDetails = $general->get_Onerow("challenges", " and challenge_id='" . $val['challenge_id'] . "'");

                // Determine if challenge is complete
                $peopleCard[$key]['complete'] = strtotime($challengesDetails['end_date']) >= time() ? "no" : "yes";
                $peopleCard[$key]['challenge_title'] = $challengesDetails['title'];

                // Fetch page details
                $page = $general->get_Onerow("page", " and id='" . $val['page_id'] . "'");
                $peopleCard[$key]['icon'] = $page['icon'];
                $peopleCard[$key]['page_title'] = $page['title'];
            }

            // Assign data for this user to the main data array
            $data = array_merge($data, $peopleCard);
        }
    }

    // Sort data based on latest created date
    usort($data, function ($a, $b) {
        return strtotime($b['date']) - strtotime($a['date']);
    });

    // Output the final data in JSON format
    echo json_encode($data);
} else {
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
