<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    $challenge_id = $_GET['challenge_id'] ?? null;

    $where = " and challenge_id =$challenge_id";

    $tasks_count = $general->get_AllRowscnt("tasks", $where);

    if ($tasks_count > 0)
    {
        $tasks_arr = $general->get_AllRows("tasks", 0, $tasks_count, "task_id asc", $where);
        $data = array();

        foreach ($tasks_arr as $key => $val)
        {
            $data[$key]['task_name'] = $val['task_name'];
            $data[$key]['task_id'] = $val['task_id'];
            $data[$key]['description'] =  $general->basedecode($val['description']);
            $task_media     = $general->get_Onerow("task_media", "and task_id=" . $val['task_id']);

            $data[$key]['image'] = $task_media['media_path'];
            if($val['task_type']=="stepCounter")
            {
                $data[$key]['type'] = "Pedometer";
            }
            if($val['task_type']=="mediaCapture")
            {
                $data[$key]['type'] = "Image Capture";
            }
            if($val['task_type']=="videoCapture")
            {
                $data[$key]['type'] = "Video Capture";
            }
            
            

            // Add other fields as needed
        }

        echo json_encode($data);
    }
    else
    {
        echo json_encode(['error' => 'No districts found']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
