<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $userId = $_GET['user_id'];
    $timeline = $_GET['timeline'];
    $user_pages = $general->get_Onerow("user_pages", " and user_id=" . $userId);
    $pageId = $user_pages['page_id'];
// echo $timeline;
    // Calculate the end date based on the timeline
    $endDate = calculateEndDate($timeline);

    // Count challenges where arena = 'yes' and end_date is within the specified timeline
    $challengesCount = $general->get_AllRowscnt("user_challenges", " AND completed='yes' AND arena = 'no' AND end_date >= '$endDate' AND page_id=" . $pageId);

    if ($challengesCount > 0) {
        // Fetch user challenges where arena = 'yes' and end_date is within the specified timeline
        $challenges = $general->get_AllRows("user_challenges", 0, 10, null, " AND completed='yes' AND arena = 'no' AND end_date >= '$endDate' AND page_id=" . $pageId);

        // Group challenges by user ID
        $userChallenges = [];
        foreach ($challenges as $challenge) {
            $userId = $challenge['user_id'];
            if (!isset($userChallenges[$userId])) {
                $userChallenges[$userId] = [];
            }
            $userChallenges[$userId][] = $challenge;
        }

        // Calculate total reward points for each user
        $userData = [];
        foreach ($userChallenges as $userId => $challenges) {
            $totalPoints = array_sum(array_column($challenges, 'reward_points'));

            // Query user details
            $userDetails = $general->get_Onerow("user_details", " and id = $userId");
            $firstCharCapitalized = ucfirst($userDetails['name'][0]);

            // Prepare user data
            $userData[] = [
                'id' => $userId,
                'name' => $userDetails['name'],
                'image' => $userDetails['image'],
                'total_points' => $totalPoints,
                'first_character' => $firstCharCapitalized,
                'user_challenges' => addEndDateToChallenges($challenges, $endDate), // Add end date to challenges
            ];
        }

        // Sort users by total reward points in descending order
        usort($userData, function ($a, $b) {
            return $b['total_points'] - $a['total_points'];
        });

        // Add ranking to user data
        foreach ($userData as $rank => &$user) {
            $user['ranking'] = $rank + 1;
        }
        $userId2 = $_GET['user_id'];
        $userDetails = $general->get_Onerow("user_details", " and id = $userId2");
        $firstCharCapitalized = ucfirst($userDetails['name'][0]);

        $singleUser = array(
            'id' => $userId,
                'name' => $userDetails['name'],
                'image' => $userDetails['image'],
                'total_points' => $totalPoints,
                'first_character' => $firstCharCapitalized,
        );
        echo json_encode(['success' => true, 'data' => $userData,'single'=>$singleUser]);
    } else {
        echo json_encode(['success' => true, 'data' => []]); // Return empty data if no challenges found
    }
} else {
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}

// Function to add end dates to user challenges based on variable date range
function addEndDateToChallenges($challenges, $endDate) {
    foreach ($challenges as &$challenge) {
        $challenge['end_date'] = $endDate;
    }
    return $challenges;
}

// Function to calculate end date based on timeline
function calculateEndDate($timeline) {
    $endDate = date('Y-m-d H:i:s'); // Current date and time by default
    switch ($timeline) {
        case 'weekly':
            $endDate = date('Y-m-d H:i:s', strtotime('-1 week'));
            break;
        case 'monthly':
            $endDate = date('Y-m-d H:i:s', strtotime('-1 month'));
            break;
        case 'yearly':
            $endDate = date('Y-m-d H:i:s', strtotime('-1 year'));
            break;
        default:
            // Handle default case
            break;
    }
    return $endDate;
}
