<?php
// assignTaskToMember.php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $challenge_id = isset($_POST['challenge_id']) ? $_POST['challenge_id'] : null;
    $task_id = isset($_POST['task_id']) ? $_POST['task_id'] : null;
    $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : null;
    $assigned_to = isset($_POST['assigned_to']) ? $_POST['assigned_to'] : null;
    
    if ($challenge_id && $task_id && $user_id && $assigned_to) {
        
        // Check if user is team leader
        $team_member = $general->get_Onerow("team_members", 
            " and challenge_id=" . $challenge_id . " and user_id=" . $user_id . " and is_leader='yes'");
        
        if (empty($team_member)) {
            echo json_encode([
                'success' => false,
                'error' => 'Only team leader can assign tasks'
            ]);
            exit;
        }
        
        // Check if member already has a task
        $existing_assignment = $general->get_Onerow("team_members", 
            " and challenge_id=" . $challenge_id . " and user_id=" . $assigned_to . " and task_id IS NOT NULL");
        
        if (!empty($existing_assignment)) {
            echo json_encode([
                'success' => false,
                'error' => 'Member already has a task assigned'
            ]);
            exit;
        }
        
        // Assign task
        $result = $general->upd_Row(
            'team_members',
            "task_id='$task_id'",
            "challenge_id='$challenge_id' AND user_id='$assigned_to'"
        );
        
        if ($result === "") {
            echo json_encode([
                'success' => true,
                'message' => 'Task assigned successfully'
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'error' => 'Failed to assign task'
            ]);
        }
        
    } else {
        echo json_encode([
            'success' => false,
            'error' => 'Missing required parameters'
        ]);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}
?>