<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $challenge_id = isset($_POST['challenge_id']) ? $_POST['challenge_id'] : null;
    $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : null;
    $task_assignments = isset($_POST['task_assignments']) ? $_POST['task_assignments'] : null;
    
    if ($challenge_id !== null && $user_id !== null && $task_assignments !== null) {
        
        // Decode task assignments
        $assignments = json_decode($task_assignments, true);
        
        if (empty($assignments)) {
            echo json_encode([
                'success' => false,
                'error' => 'No task assignments provided'
            ]);
            exit;
        }
        
        try {
            // Check if user is already in this team
            $existing_member = $general->get_Onerow("team_members", 
                " and challenge_id=" . $challenge_id . " and user_id=" . $user_id);
            
            if (!empty($existing_member)) {
                echo json_encode([
                    'success' => false,
                    'error' => 'User is already part of this team challenge'
                ]);
                exit;
            }
            
            // Get challenge details
            $challenge_details = $general->get_Onerow("challenges", " and challenge_id=" . $challenge_id);
            if (empty($challenge_details)) {
                echo json_encode([
                    'success' => false,
                    'error' => 'Challenge not found'
                ]);
                exit;
            }
            
            $current_members = 1; // Start with the creator
            $errors = array();
            
            // First, add the creator as team leader
            $leader_result = $general->ins_Row(
                'team_members',
                'challenge_id, user_id, is_leader, joined_date, status',
                "'$challenge_id', '$user_id', 'yes', NOW(), 'active'"
            );
            
            if ($leader_result !== "") {
                echo json_encode([
                    'success' => false,
                    'error' => 'Failed to add team leader: ' . $leader_result
                ]);
                exit;
            }
            
            // Process task assignments
            foreach ($assignments as $task_id => $member_data) {
                if ($member_data['id'] === 'current_user') {
                    // Update leader's task assignment
                    $update_result = $general->upd_Row(
                        'team_members',
                        "task_id='$task_id'",
                        "challenge_id='$challenge_id' AND user_id='$user_id'"
                    );
                    
                    if ($update_result !== "") {
                        $errors[] = "Failed to assign task to leader";
                    }
                } else {
                    // Add friend to team
                    $member_id = $member_data['id'];
                    
                    // Check if this user exists
                    $user_exists = $general->get_Onerow("user_details", " and id=" . $member_id);
                    if (empty($user_exists)) {
                        $errors[] = "User ID " . $member_id . " not found";
                        continue;
                    }
                    
                    // Check if member is already in this team
                    $existing_team_member = $general->get_Onerow("team_members", 
                        " and challenge_id=" . $challenge_id . " and user_id=" . $member_id);
                    
                    if (!empty($existing_team_member)) {
                        $errors[] = $member_data['name'] . " is already in this team";
                        continue;
                    }
                    
                    $member_result = $general->ins_Row(
                        'team_members',
                        'challenge_id, user_id, task_id, is_leader, joined_date, status',
                        "'$challenge_id', '$member_id', '$task_id', 'no', NOW(), 'active'"
                    );
                    
                    if ($member_result !== "") {
                        $errors[] = "Failed to add " . $member_data['name'] . " to team";
                    } else {
                        $current_members++;
                        
                        // Create invitation record if table exists
                        $invitation_result = $general->ins_Row(
                            'team_invitations',
                            'challenge_id, inviter_id, invitee_id, status, created_date',
                            "'$challenge_id', '$user_id', '$member_id', 'accepted', NOW()"
                        );
                        // Don't fail if invitation table doesn't exist
                    }
                }
            }
            
            // Update challenge member count and status
            $min_members = isset($challenge_details['min_members']) ? $challenge_details['min_members'] : 2;
            $team_status = $current_members >= $min_members ? 'active' : 'forming';
            
            $challenge_update = $general->upd_Row(
                'challenges',
                "current_members='$current_members', team_status='$team_status'",
                "challenge_id='$challenge_id'"
            );
            
            if ($challenge_update !== "") {
                $errors[] = "Failed to update challenge status";
            }
            
            // Add user to user_challenges table
            $user_challenge_result = $general->ins_Row(
                'user_challenges',
                'challenge_id, user_id, start_date, reward_points, arena, page_id, completed, visit, team_challenge',
                "'$challenge_id', '$user_id', NOW(), '0', 'no', '" . $challenge_details['page_id'] . "', 'no', 'no', 'yes'"
            );
            
            if ($user_challenge_result !== "") {
                $errors[] = "Failed to add user challenge record";
            }
            
            if (empty($errors)) {
                echo json_encode([
                    'success' => true,
                    'message' => 'Team challenge created successfully',
                    'team_id' => $challenge_id,
                    'members_count' => $current_members
                ]);
            } else {
                echo json_encode([
                    'success' => false,
                    'error' => 'Some operations failed: ' . implode(', ', $errors),
                    'partial_success' => true
                ]);
            }
            
        } catch (Exception $e) {
            echo json_encode([
                'success' => false,
                'error' => 'Database error: ' . $e->getMessage()
            ]);
        }
        
    } else {
        echo json_encode([
            'success' => false,
            'error' => 'Missing required parameters: challenge_id, user_id, or task_assignments'
        ]);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}
?>